/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.simulare;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

@Mojo(name="transform", defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class TransformMojo
extends AbstractMojo {
    @Parameter(property="project.build.outputDirectory", required=true)
    private File classDirectory;
    private int classCount;
    private int transformCount;

    public void execute() throws MojoExecutionException {
        this.walk(this.classDirectory, new SuffixFilter(".class"));
        this.getLog().info((CharSequence)("Read " + this.classCount + " class" + this.plural(this.classCount, "es") + ", transformed " + this.transformCount + " instance" + this.plural(this.transformCount, "s") + " of Java 7-isms."));
    }

    private String plural(int count, String plural) {
        return count != 1 ? plural : "";
    }

    private void walk(File dir, FileFilter filter) throws MojoExecutionException {
        for (File file : dir.listFiles(filter)) {
            if (file.isDirectory()) {
                this.walk(file, filter);
                continue;
            }
            this.process(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(File file) throws MojoExecutionException {
        try {
            ClassReader reader;
            FileInputStream is = new FileInputStream(file);
            try {
                reader = new ClassReader((InputStream)is);
            }
            finally {
                is.close();
            }
            ClassWriter writer = new ClassWriter(reader, 0);
            ClassTransformer transformer = new ClassTransformer((ClassVisitor)writer);
            reader.accept((ClassVisitor)transformer, 0);
            FileOutputStream out = new FileOutputStream(file);
            try {
                out.write(writer.toByteArray());
            }
            finally {
                out.close();
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error whilst reading / writing class file : " + file, (Exception)ex);
        }
    }

    private static class SuffixFilter
    implements FileFilter {
        private final String suffix;

        public SuffixFilter(String suffix) {
            this.suffix = suffix;
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().endsWith(this.suffix);
        }
    }

    private class ClassTransformer
    extends ClassVisitor {
        public ClassTransformer(ClassVisitor cv) {
            super(327680, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (version > 51) {
                throw new RuntimeException("Cannot transform classes greater than Java 1.7");
            }
            TransformMojo.this.classCount++;
            super.visit(version == 51 ? 50 : version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MethodTransformer(super.visitMethod(access, name, desc, signature, exceptions));
        }

        private class MethodTransformer
        extends MethodVisitor {
            public MethodTransformer(MethodVisitor mv) {
                super(327680, mv);
            }

            public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
                throw new RuntimeException("InvokeDynamic instructions not supported");
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (owner.equals("java/lang/Throwable") && name.equals("addSuppressed")) {
                    Label start = new Label();
                    Label end = new Label();
                    Label handler = new Label();
                    super.visitTryCatchBlock(start, end, handler, "java/lang/NoSuchMethodError");
                    super.visitLabel(start);
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                    super.visitLabel(end);
                    Label next = new Label();
                    super.visitJumpInsn(167, next);
                    super.visitLabel(handler);
                    super.visitInsn(87);
                    super.visitLabel(next);
                    TransformMojo.this.transformCount++;
                } else {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            }
        }
    }
}

