/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.hocon;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigOriginFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.commented.SimpleCommentedConfigurationNode;
import ninja.leaping.configurate.loader.AbstractConfigurationLoader;
import ninja.leaping.configurate.loader.CommentHandler;
import ninja.leaping.configurate.loader.CommentHandlers;

public class HoconConfigurationLoader
extends AbstractConfigurationLoader<CommentedConfigurationNode> {
    public static final Pattern CRLF_MATCH;
    private final ConfigRenderOptions render;
    private final ConfigParseOptions parse;
    private static final ConfigOrigin CONFIGURATE_ORIGIN;
    private static final Constructor<? extends ConfigValue> CONFIG_OBJECT_CONSTRUCTOR;
    private static final Constructor<? extends ConfigValue> CONFIG_LIST_CONSTRUCTOR;

    public static Builder builder() {
        return new Builder();
    }

    private HoconConfigurationLoader(Builder build) {
        super((AbstractConfigurationLoader.Builder)build, new CommentHandler[]{CommentHandlers.HASH, CommentHandlers.DOUBLE_SLASH});
        this.render = build.getRenderOptions();
        this.parse = build.getParseOptions();
    }

    public void loadInternal(CommentedConfigurationNode node, BufferedReader reader) throws IOException {
        Config hoconConfig = ConfigFactory.parseReader((Reader)reader, (ConfigParseOptions)this.parse);
        hoconConfig = hoconConfig.resolve();
        for (Map.Entry ent : hoconConfig.root().entrySet()) {
            this.readConfigValue((ConfigValue)ent.getValue(), node.getNode(new Object[]{ent.getKey()}));
        }
    }

    private void readConfigValue(ConfigValue value, CommentedConfigurationNode node) {
        if (!value.origin().comments().isEmpty()) {
            node.setComment(CRLF_MATCH.matcher(Joiner.on((char)'\n').join((Iterable)value.origin().comments())).replaceAll(""));
        }
        switch (value.valueType()) {
            case OBJECT: {
                if (((ConfigObject)value).isEmpty()) {
                    node.setValue((Object)ImmutableMap.of());
                    break;
                }
                for (Map.Entry ent : ((ConfigObject)value).entrySet()) {
                    this.readConfigValue((ConfigValue)ent.getValue(), node.getNode(new Object[]{ent.getKey()}));
                }
                break;
            }
            case LIST: {
                ConfigList values = (ConfigList)value;
                for (int i = 0; i < values.size(); ++i) {
                    this.readConfigValue((ConfigValue)values.get(i), node.getNode(new Object[]{i}));
                }
                break;
            }
            case NULL: {
                return;
            }
            default: {
                node.setValue(value.unwrapped());
            }
        }
    }

    protected void saveInternal(ConfigurationNode node, Writer writer) throws IOException {
        if (!node.hasMapChildren()) {
            if (node.getValue() == null) {
                writer.write(SYSTEM_LINE_SEPARATOR);
                return;
            }
            throw new IOException("HOCON cannot write nodes not in map format!");
        }
        ConfigValue value = this.fromValue(node);
        String renderedValue = value.render(this.render);
        writer.write(renderedValue);
    }

    private ConfigValue fromValue(ConfigurationNode node) {
        ConfigValue ret;
        Object children;
        if (node.hasMapChildren()) {
            children = node.getOptions().getMapFactory().create();
            for (Map.Entry ent : node.getChildrenMap().entrySet()) {
                children.put(String.valueOf(ent.getKey()), this.fromValue((ConfigurationNode)ent.getValue()));
            }
            ret = this.newConfigObject((Map<String, ConfigValue>)children);
        } else if (node.hasListChildren()) {
            children = new ArrayList();
            for (ConfigurationNode ent : node.getChildrenList()) {
                children.add(this.fromValue(ent));
            }
            ret = this.newConfigList((List<ConfigValue>)children);
        } else {
            ret = ConfigValueFactory.fromAnyRef((Object)node.getValue(), (String)"configurate-hocon");
        }
        if (node instanceof CommentedConfigurationNode) {
            CommentedConfigurationNode commentedNode = (CommentedConfigurationNode)node;
            ConfigValue finalRet = ret;
            ret = commentedNode.getComment().map(comment -> finalRet.withOrigin(finalRet.origin().withComments(LINE_SPLITTER.splitToList((CharSequence)comment)))).orElse(ret);
        }
        return ret;
    }

    ConfigValue newConfigObject(Map<String, ConfigValue> vals) {
        try {
            return CONFIG_OBJECT_CONSTRUCTOR.newInstance(CONFIGURATE_ORIGIN, vals);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    ConfigValue newConfigList(List<ConfigValue> vals) {
        try {
            return CONFIG_LIST_CONSTRUCTOR.newInstance(CONFIGURATE_ORIGIN, vals);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public CommentedConfigurationNode createEmptyNode(ConfigurationOptions options) {
        options = options.setAcceptedTypes((Set)ImmutableSet.of(Map.class, List.class, Double.class, Long.class, Integer.class, Boolean.class, (Object[])new Class[]{String.class, Number.class}));
        return SimpleCommentedConfigurationNode.root((ConfigurationOptions)options);
    }

    static {
        Class<ConfigValue> listClass;
        Class<ConfigValue> objectClass;
        CRLF_MATCH = Pattern.compile("\r\n?");
        CONFIGURATE_ORIGIN = ConfigOriginFactory.newSimple((String)"configurate-hocon");
        try {
            objectClass = Class.forName("com.typesafe.config.impl.SimpleConfigObject").asSubclass(ConfigValue.class);
            listClass = Class.forName("com.typesafe.config.impl.SimpleConfigList").asSubclass(ConfigValue.class);
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(e);
        }
        try {
            CONFIG_OBJECT_CONSTRUCTOR = objectClass.getDeclaredConstructor(ConfigOrigin.class, Map.class);
            CONFIG_OBJECT_CONSTRUCTOR.setAccessible(true);
            CONFIG_LIST_CONSTRUCTOR = listClass.getDeclaredConstructor(ConfigOrigin.class, List.class);
            CONFIG_LIST_CONSTRUCTOR.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static class Builder
    extends AbstractConfigurationLoader.Builder<Builder> {
        private ConfigRenderOptions render = ConfigRenderOptions.defaults().setOriginComments(false).setJson(false);
        private ConfigParseOptions parse = ConfigParseOptions.defaults();

        protected Builder() {
        }

        public ConfigRenderOptions getRenderOptions() {
            return this.render;
        }

        public ConfigParseOptions getParseOptions() {
            return this.parse;
        }

        public Builder setRenderOptions(ConfigRenderOptions options) {
            this.render = options;
            return this;
        }

        public Builder setParseOptions(ConfigParseOptions options) {
            this.parse = options;
            return this;
        }

        public HoconConfigurationLoader build() {
            return new HoconConfigurationLoader(this);
        }
    }
}

