/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.eventgencore;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.spongepowered.api.eventgencore.NonNullUniqueQueue;
import org.spongepowered.api.eventgencore.Property;
import org.spongepowered.api.eventgencore.PropertySearchStrategy;
import org.spongepowered.api.eventgencore.classwrapper.ClassWrapper;
import org.spongepowered.api.eventgencore.classwrapper.MethodWrapper;

public class AccessorFirstStrategy<T, M>
implements PropertySearchStrategy<T, M> {
    private static final Pattern ACCESSOR = Pattern.compile("^get([A-Z].*)");
    private static final Pattern ACCESSOR_BOOL = Pattern.compile("^is([A-Z].*)");
    private static final Pattern ACCESSOR_HAS = Pattern.compile("^has([A-Z].*)");
    private static final Pattern ACCESSOR_KEEPS = Pattern.compile("^(keeps[A-Z].*)");
    private static final Pattern MUTATOR = Pattern.compile("^set([A-Z].*)");

    private String getAccessorName(MethodWrapper<T, M> method) {
        if (method.isPublic() && method.getParameterTypes().size() == 0) {
            String methodName = method.getName();
            ClassWrapper<T, M> returnType = method.getReturnType();
            Matcher m = ACCESSOR.matcher(methodName);
            if (m.matches() && !returnType.isPrimitive(Void.TYPE)) {
                return AccessorFirstStrategy.getPropertyName(m.group(1));
            }
            m = ACCESSOR_BOOL.matcher(methodName);
            if (m.matches() && returnType.isPrimitive(Boolean.TYPE)) {
                return AccessorFirstStrategy.getPropertyName(m.group(1));
            }
            m = ACCESSOR_KEEPS.matcher(methodName);
            if (m.matches() && returnType.isPrimitive(Boolean.TYPE)) {
                return AccessorFirstStrategy.getPropertyName(m.group(1));
            }
            m = ACCESSOR_HAS.matcher(methodName);
            if (m.matches() && returnType.isPrimitive(Boolean.TYPE)) {
                return AccessorFirstStrategy.getPropertyName(methodName);
            }
        }
        return null;
    }

    @Nullable
    private String getMutatorName(MethodWrapper<T, M> method) {
        Matcher m;
        if (method.isPublic() && method.getParameterTypes().size() == 1 && method.getReturnType().getActualClass().equals(Void.TYPE) && (m = MUTATOR.matcher(method.getName())).matches()) {
            return AccessorFirstStrategy.getPropertyName(m.group(1));
        }
        return null;
    }

    public static String getPropertyName(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    @Nullable
    protected MethodWrapper<T, M> findMutator(MethodWrapper<T, M> accessor, Collection<MethodWrapper<T, M>> candidates) {
        T expectedType = accessor.getReturnType().getActualClass();
        for (MethodWrapper<T, M> method : candidates) {
            if (!method.getParameterTypes().get(0).getActualClass().equals(expectedType) && !expectedType.equals(Optional.class)) continue;
            return method;
        }
        return null;
    }

    @Override
    public ImmutableSet<? extends Property<T, M>> findProperties(ClassWrapper<T, M> type) {
        ClassWrapper scannedType;
        Preconditions.checkNotNull(type, (Object)"type");
        HashMultimap accessors = HashMultimap.create();
        HashMultimap mutators = HashMultimap.create();
        NonNullUniqueQueue queue = new NonNullUniqueQueue();
        HashMap accessorHierarchyBottoms = new HashMap();
        HashMap mostSpecific = new HashMap();
        HashSet<String> signatures = new HashSet<String>();
        queue.add(type);
        while ((scannedType = (ClassWrapper)queue.poll()) != null) {
            for (MethodWrapper method : scannedType.getMethods()) {
                MethodWrapper leastSpecificMethod;
                String signature = method.getName() + ";";
                for (ClassWrapper parameterType : method.getParameterTypes()) {
                    signature = signature + parameterType.getName() + ";";
                }
                signature = signature + method.getReturnType().getName();
                String name = this.getAccessorName(method);
                if (!(name == null || signatures.contains(signature) || (leastSpecificMethod = (MethodWrapper)accessorHierarchyBottoms.get(name)) != null && leastSpecificMethod.getReturnType().equals(method.getReturnType()))) {
                    accessors.put((Object)name, method);
                    signatures.add(signature);
                    if (!mostSpecific.containsKey(name) || method.getReturnType().isSubtypeOf(((MethodWrapper)mostSpecific.get(name)).getReturnType())) {
                        mostSpecific.put(name, method);
                    }
                    if (accessorHierarchyBottoms.get(name) != null && !((MethodWrapper)accessorHierarchyBottoms.get(name)).getReturnType().isSubtypeOf(method.getReturnType())) continue;
                    accessorHierarchyBottoms.put(name, method);
                    continue;
                }
                name = this.getMutatorName(method);
                if (name == null) continue;
                mutators.put((Object)name, method);
            }
            scannedType.getInterfaces().forEach(queue::offer);
            queue.offer(scannedType.getSuperclass());
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (Map.Entry entry : accessors.entries()) {
            MethodWrapper accessor = (MethodWrapper)entry.getValue();
            MethodWrapper<T, M> mutator = this.findMutator((MethodWrapper)entry.getValue(), mutators.get(entry.getKey()));
            result.add(new Property((String)entry.getKey(), accessor.getReturnType(), (MethodWrapper)accessorHierarchyBottoms.get(entry.getKey()), (MethodWrapper)mostSpecific.get(entry.getKey()), accessor, mutator));
        }
        return result.build();
    }
}

