/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.eventgencore;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.eventgencore.classwrapper.ClassWrapper;
import org.spongepowered.api.eventgencore.classwrapper.MethodWrapper;

public final class Property<T, M>
implements Comparable<Property<T, M>> {
    private final String name;
    private final ClassWrapper<T, M> type;
    private final MethodWrapper<T, M> leastSpecificMethod;
    private final MethodWrapper<T, M> mostSpecificMethod;
    private final MethodWrapper<T, M> accessor;
    private final Optional<MethodWrapper<T, M>> mutator;

    public Property(String name, ClassWrapper<T, M> type, MethodWrapper<T, M> leastSpecificMethod, MethodWrapper<T, M> mostSpecificMethod, MethodWrapper<T, M> accessor, @Nullable MethodWrapper<T, M> mutator) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull(type, (Object)"type");
        Preconditions.checkNotNull(leastSpecificMethod, (Object)"leastSpecificMethod");
        Preconditions.checkNotNull(mostSpecificMethod, (Object)"mostSpecificMethod");
        Preconditions.checkNotNull(accessor, (Object)"accessor");
        this.name = name;
        this.type = type;
        this.leastSpecificMethod = leastSpecificMethod;
        this.mostSpecificMethod = mostSpecificMethod;
        this.accessor = accessor;
        this.mutator = Optional.ofNullable(mutator);
    }

    public String getName() {
        return this.name;
    }

    public T getType() {
        return this.type.getActualClass();
    }

    public M getLeastSpecificMethod() {
        return this.leastSpecificMethod.getActualMethod();
    }

    public T getLeastSpecificType() {
        return this.leastSpecificMethod.getReturnType().getActualClass();
    }

    public M getMostSpecificMethod() {
        return this.mostSpecificMethod.getActualMethod();
    }

    public T getMostSpecificType() {
        return this.mostSpecificMethod.getReturnType().getActualClass();
    }

    public M getAccessor() {
        return this.accessor.getActualMethod();
    }

    public MethodWrapper<T, M> getAccessorWrapper() {
        return this.accessor;
    }

    public Optional<M> getMutator() {
        return this.mutator.map(MethodWrapper::getActualMethod);
    }

    public boolean isLeastSpecificType() {
        return this.type.getActualClass().equals(this.leastSpecificMethod.getReturnType().getActualClass());
    }

    public boolean isMostSpecificType() {
        return this.type.getActualClass().equals(this.mostSpecificMethod.getReturnType().getActualClass());
    }

    @Override
    public int compareTo(Property<T, M> otherProperty) {
        return this.getName().compareTo(otherProperty.getName());
    }
}

