/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.eventgencore.classwrapper.reflection;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.spongepowered.api.eventgencore.classwrapper.ClassWrapper;
import org.spongepowered.api.eventgencore.classwrapper.MethodWrapper;
import org.spongepowered.api.eventgencore.classwrapper.reflection.ReflectionMethodWrapper;

public class ReflectionClassWrapper
implements ClassWrapper<Class<?>, Method> {
    private final Class<?> clazz;

    public ReflectionClassWrapper(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public String getName() {
        return this.clazz.getName();
    }

    @Override
    public List<MethodWrapper<Class<?>, Method>> getMethods() {
        return Stream.of(this.clazz.getMethods()).map(ReflectionMethodWrapper::new).collect(Collectors.toList());
    }

    @Override
    public boolean isSubtypeOf(ClassWrapper<Class<?>, Method> other) {
        return other.getActualClass().isAssignableFrom(this.clazz);
    }

    @Override
    public List<ClassWrapper<Class<?>, Method>> getInterfaces() {
        return Stream.of(this.clazz.getInterfaces()).map(ReflectionClassWrapper::new).collect(Collectors.toList());
    }

    @Override
    public ClassWrapper<Class<?>, Method> getSuperclass() {
        if (this.clazz.getSuperclass() != null) {
            return new ReflectionClassWrapper(this.clazz.getSuperclass());
        }
        return null;
    }

    @Override
    public Class<?> getActualClass() {
        return this.clazz;
    }

    @Override
    public boolean isPrimitive(Class<?> other) {
        return this.clazz.equals(other);
    }
}

