/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.eventgencore.classwrapper.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.spongepowered.api.eventgencore.classwrapper.ClassWrapper;
import org.spongepowered.api.eventgencore.classwrapper.MethodWrapper;
import org.spongepowered.api.eventgencore.classwrapper.reflection.ReflectionClassWrapper;

public class ReflectionMethodWrapper
implements MethodWrapper<Class<?>, Method> {
    private final Method method;

    public ReflectionMethodWrapper(Method method) {
        this.method = method;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.method.getModifiers());
    }

    @Override
    public ClassWrapper<Class<?>, Method> getReturnType() {
        return new ReflectionClassWrapper(this.method.getReturnType());
    }

    @Override
    public List<ClassWrapper<Class<?>, Method>> getParameterTypes() {
        return Stream.of(this.method.getParameterTypes()).map(ReflectionClassWrapper::new).collect(Collectors.toList());
    }

    @Override
    public Method getActualMethod() {
        return this.method;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotation) {
        return this.method.getAnnotation(annotation);
    }

    @Override
    public ClassWrapper<Class<?>, Method> getEnclosingClass() {
        return new ReflectionClassWrapper(this.method.getDeclaringClass());
    }
}

