/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.eventgencore.classwrapper.reflection;

import java.util.ArrayDeque;
import org.spongepowered.api.eventgencore.annotation.ImplementedBy;
import org.spongepowered.api.eventgencore.classwrapper.reflection.ReflectionClassWrapper;

public class ReflectionUtils {
    public static ReflectionClassWrapper getBaseClass(Class<?> target) {
        Class scannedType;
        ImplementedBy implementedBy = null;
        int max = -1;
        ArrayDeque queue = new ArrayDeque();
        queue.add(target);
        while ((scannedType = (Class)queue.poll()) != null) {
            ImplementedBy anno = scannedType.getAnnotation(ImplementedBy.class);
            if (anno != null && (anno.priority() == -1 || anno.priority() > max)) {
                implementedBy = anno;
                max = anno.priority();
            }
            for (Class<?> implInterfaces : scannedType.getInterfaces()) {
                queue.offer(implInterfaces);
            }
        }
        if (implementedBy != null) {
            return new ReflectionClassWrapper(implementedBy.value());
        }
        return new ReflectionClassWrapper(Object.class);
    }
}

