/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.modify.AfterStoreLocal;
import org.spongepowered.asm.mixin.injection.modify.BeforeLoadLocal;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.points.AfterInvoke;
import org.spongepowered.asm.mixin.injection.points.BeforeFieldAccess;
import org.spongepowered.asm.mixin.injection.points.BeforeInvoke;
import org.spongepowered.asm.mixin.injection.points.BeforeNew;
import org.spongepowered.asm.mixin.injection.points.BeforeReturn;
import org.spongepowered.asm.mixin.injection.points.BeforeStringInvoke;
import org.spongepowered.asm.mixin.injection.points.JumpInsnPoint;
import org.spongepowered.asm.mixin.injection.points.MethodHead;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.refmap.IReferenceMapperContext;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.util.ASMHelper;

public abstract class InjectionPoint {
    public abstract boolean find(String var1, InsnList var2, Collection<AbstractInsnNode> var3);

    public String toString() {
        return "InjectionPoint(" + this.getClass().getSimpleName() + ")";
    }

    protected static AbstractInsnNode nextNode(InsnList insns, AbstractInsnNode insn) {
        int index = insns.indexOf(insn) + 1;
        if (index > 0 && index < insns.size()) {
            return insns.get(index);
        }
        return insn;
    }

    public static InjectionPoint and(InjectionPoint ... operands) {
        return new Intersection(operands);
    }

    public static InjectionPoint or(InjectionPoint ... operands) {
        return new Union(operands);
    }

    public static InjectionPoint after(InjectionPoint point) {
        return new Shift(point, 1);
    }

    public static InjectionPoint before(InjectionPoint point) {
        return new Shift(point, -1);
    }

    public static InjectionPoint shift(InjectionPoint point, int count) {
        return new Shift(point, count);
    }

    public static InjectionPoint parse(MixinTargetContext mixin, MethodNode method, AnnotationNode parent, At at) {
        List<String> args = Arrays.asList(at.args());
        return InjectionPoint.parse(mixin, method, parent, at.value(), at.shift(), at.by(), args, at.target(), at.ordinal(), at.opcode());
    }

    public static InjectionPoint parse(MixinTargetContext mixin, MethodNode method, AnnotationNode parent, AnnotationNode node) {
        String at = (String)ASMHelper.getAnnotationValue(node, "value");
        List args = (List)ASMHelper.getAnnotationValue(node, "args");
        String target = ASMHelper.getAnnotationValue(node, "target", "");
        At.Shift shift = ASMHelper.getAnnotationValue(node, "shift", At.Shift.class, At.Shift.NONE);
        int by = ASMHelper.getAnnotationValue(node, "by", 0);
        int ordinal = ASMHelper.getAnnotationValue(node, "ordinal", -1);
        int opcode = ASMHelper.getAnnotationValue(node, "opcode", 0);
        if (args == null) {
            args = ImmutableList.of();
        }
        return InjectionPoint.parse(mixin, method, parent, at, shift, by, args, target, ordinal, opcode);
    }

    public static InjectionPoint parse(MixinTargetContext mixin, MethodNode method, AnnotationNode parent, String at, At.Shift shift, int by, List<String> args, String target, int ordinal, int opcode) {
        InjectionPointData data = new InjectionPointData(mixin, method, parent, at, args, target, ordinal, opcode);
        InjectionPoint point = null;
        if ("FIELD".equals(at)) {
            point = new BeforeFieldAccess(data);
        } else if ("INVOKE".equals(at)) {
            point = new BeforeInvoke(data);
        } else if ("NEW".equals(at)) {
            point = new BeforeNew(data);
        } else if ("RETURN".equals(at)) {
            point = new BeforeReturn(data);
        } else if ("INVOKE_STRING".equals(at)) {
            point = new BeforeStringInvoke(data);
        } else if ("JUMP".equals(at)) {
            point = new JumpInsnPoint(data);
        } else if ("HEAD".equals(at)) {
            point = new MethodHead(data);
        } else if ("INVOKE_ASSIGN".equals(at)) {
            point = new AfterInvoke(data);
        } else if ("LOAD".equals(at)) {
            LocalVariableDiscriminator discriminator = LocalVariableDiscriminator.parse(parent);
            point = new BeforeLoadLocal(mixin, Type.getReturnType(method.desc), discriminator, data);
        } else if ("STORE".equals(at)) {
            LocalVariableDiscriminator discriminator = LocalVariableDiscriminator.parse(parent);
            point = new AfterStoreLocal(mixin, Type.getReturnType(method.desc), discriminator, data);
        } else if (at.matches("^([A-Za-z_][A-Za-z0-9_]*\\.)+[A-Za-z_][A-Za-z0-9_]*$")) {
            try {
                Class<?> cls = Class.forName(at);
                Constructor<?> ctor = cls.getDeclaredConstructor(InjectionPointData.class);
                ctor.setAccessible(true);
                point = (InjectionPoint)ctor.newInstance(data);
            }
            catch (Exception ex) {
                throw new InvalidInjectionException(mixin, "The specified class " + at + " could not be instanced or is not a valid InjectionPoint", (Throwable)ex);
            }
        } else {
            throw new InvalidInjectionException((IReferenceMapperContext)mixin, at + " is not a valid injection point specifier");
        }
        if (point != null) {
            if (shift == At.Shift.BEFORE) {
                return InjectionPoint.before(point);
            }
            if (shift == At.Shift.AFTER) {
                return InjectionPoint.after(point);
            }
            if (shift == At.Shift.BY) {
                return InjectionPoint.shift(point, by);
            }
        }
        return point;
    }

    static final class Shift
    extends InjectionPoint {
        private final InjectionPoint input;
        private final int shift;

        public Shift(InjectionPoint input, int shift) {
            if (input == null) {
                throw new IllegalArgumentException("Must supply an input injection point for SHIFT");
            }
            this.input = input;
            this.shift = shift;
        }

        @Override
        public String toString() {
            return "InjectionPoint(" + this.getClass().getSimpleName() + ")[" + this.input + "]";
        }

        @Override
        public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes) {
            List<Object> list = nodes instanceof List ? (List<Object>)nodes : new ArrayList<AbstractInsnNode>(nodes);
            this.input.find(desc, insns, nodes);
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, insns.get(insns.indexOf((AbstractInsnNode)list.get(i)) + this.shift));
            }
            if (nodes != list) {
                nodes.clear();
                nodes.addAll((Collection<AbstractInsnNode>)list);
            }
            return nodes.size() > 0;
        }
    }

    static final class Union
    extends CompositeInjectionPoint {
        public Union(InjectionPoint ... points) {
            super(points);
        }

        @Override
        public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes) {
            LinkedHashSet<AbstractInsnNode> allNodes = new LinkedHashSet<AbstractInsnNode>();
            for (int i = 0; i < this.components.length; ++i) {
                this.components[i].find(desc, insns, allNodes);
            }
            nodes.addAll(allNodes);
            return allNodes.size() > 0;
        }
    }

    static final class Intersection
    extends CompositeInjectionPoint {
        public Intersection(InjectionPoint ... points) {
            super(points);
        }

        @Override
        public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes) {
            boolean found = false;
            ArrayList[] allNodes = (ArrayList[])Array.newInstance(ArrayList.class, this.components.length);
            for (int i = 0; i < this.components.length; ++i) {
                allNodes[i] = new ArrayList();
                this.components[i].find(desc, insns, allNodes[i]);
            }
            ArrayList alpha = allNodes[0];
            for (int nodeIndex = 0; nodeIndex < alpha.size(); ++nodeIndex) {
                AbstractInsnNode node = (AbstractInsnNode)alpha.get(nodeIndex);
                boolean in = true;
                for (int b = 1; b < allNodes.length && allNodes[b].contains(node); ++b) {
                }
                if (!in) continue;
                nodes.add(node);
                found = true;
            }
            return found;
        }
    }

    static abstract class CompositeInjectionPoint
    extends InjectionPoint {
        protected final InjectionPoint[] components;

        protected CompositeInjectionPoint(InjectionPoint ... components) {
            if (components == null || components.length < 2) {
                throw new IllegalArgumentException("Must supply two or more component injection points for composite point!");
            }
            this.components = components;
        }

        @Override
        public String toString() {
            return "CompositeInjectionPoint(" + this.getClass().getSimpleName() + ")[" + Joiner.on((char)',').join((Object[])this.components) + "]";
        }
    }
}

