/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;

public class MethodMapper {
    private static final Logger logger = LogManager.getLogger((String)"mixin");
    private static final Map<String, Counter> methodIndices = new HashMap<String, Counter>();
    private final ClassInfo info;

    public MethodMapper(MixinEnvironment env, ClassInfo info) {
        this.info = info;
    }

    public ClassInfo getClassInfo() {
        return this.info;
    }

    public void remapHandlerMethod(MixinInfo mixin, MethodNode handler, ClassInfo.Method method) {
        if (!(handler instanceof MixinInfo.MixinMethodNode) || !((MixinInfo.MixinMethodNode)handler).isInjector()) {
            return;
        }
        if (method.isUnique()) {
            logger.warn("Redundant @Unique on injector method {} in {}. Injectors are implicitly unique", new Object[]{method, mixin});
        }
        if (method.isRenamed()) {
            handler.name = method.getName();
            return;
        }
        String handlerName = this.getHandlerName((MixinInfo.MixinMethodNode)handler);
        handler.name = method.renameTo(handlerName);
    }

    public String getHandlerName(MixinInfo.MixinMethodNode method) {
        String descriptor = String.format("%s%s", method.name, method.desc);
        Counter id = methodIndices.get(descriptor);
        if (id == null) {
            id = new Counter();
            methodIndices.put(descriptor, id);
        } else if (!method.isSurrogate()) {
            ++id.value;
        }
        String prefix = InjectionInfo.getInjectorPrefix(method.getInjectorAnnotation());
        String uniqueIndex = Integer.toHexString(id.value);
        return String.format("%s$%s$%s", prefix, method.name, uniqueIndex);
    }

    static class Counter {
        public int value;

        Counter() {
        }
    }
}

