/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.refmap.IReferenceMapperContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.InterfaceInfo;
import org.spongepowered.asm.mixin.transformer.MethodMapper;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.meta.MixinRenamed;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.util.ASMHelper;

class MixinPreProcessorStandard {
    private static final Logger logger = LogManager.getLogger((String)"mixin");
    protected final MixinInfo mixin;
    protected final MixinInfo.MixinClassNode classNode;
    private final boolean verboseLogging;
    private final boolean strictUnique;
    private boolean prepared;
    private boolean attached;

    MixinPreProcessorStandard(MixinInfo mixin, MixinInfo.MixinClassNode classNode) {
        this.mixin = mixin;
        this.classNode = classNode;
        MixinEnvironment env = mixin.getParent().getEnvironment();
        this.verboseLogging = env.getOption(MixinEnvironment.Option.DEBUG_VERBOSE);
        this.strictUnique = env.getOption(MixinEnvironment.Option.DEBUG_UNIQUE);
    }

    MixinPreProcessorStandard prepare() {
        if (this.prepared) {
            return this;
        }
        this.prepared = true;
        for (MixinInfo.MixinMethodNode mixinMethod : this.classNode.mixinMethods) {
            ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethod);
            this.prepareMethod(mixinMethod, method);
        }
        for (FieldNode mixinField : this.classNode.fields) {
            this.prepareField(mixinField);
        }
        return this;
    }

    protected void prepareMethod(MixinInfo.MixinMethodNode mixinMethod, ClassInfo.Method method) {
        this.prepareShadow(mixinMethod, method);
        this.prepareSoftImplements(mixinMethod, method);
    }

    protected void prepareShadow(MixinInfo.MixinMethodNode mixinMethod, ClassInfo.Method method) {
        AnnotationNode shadowAnnotation = ASMHelper.getVisibleAnnotation(mixinMethod, Shadow.class);
        if (shadowAnnotation == null) {
            return;
        }
        String prefix = (String)ASMHelper.getAnnotationValue(shadowAnnotation, "prefix", Shadow.class);
        if (mixinMethod.name.startsWith(prefix)) {
            ASMHelper.setVisibleAnnotation(mixinMethod, MixinRenamed.class, "originalName", mixinMethod.name);
            String newName = mixinMethod.name.substring(prefix.length());
            mixinMethod.name = method.renameTo(newName);
        }
    }

    protected void prepareSoftImplements(MixinInfo.MixinMethodNode mixinMethod, ClassInfo.Method method) {
        for (InterfaceInfo iface : this.mixin.getSoftImplements()) {
            if (!iface.renameMethod(mixinMethod)) continue;
            method.renameTo(mixinMethod.name);
        }
    }

    protected void prepareField(FieldNode mixinField) {
    }

    MixinPreProcessorStandard conform(TargetClassContext target) {
        return this.conform(target.getClassInfo());
    }

    MixinPreProcessorStandard conform(ClassInfo target) {
        for (MixinInfo.MixinMethodNode mixinMethod : this.classNode.mixinMethods) {
            if (!mixinMethod.isInjector()) continue;
            ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethod, 10);
            this.conformInjector(target, mixinMethod, method);
        }
        return this;
    }

    private void conformInjector(ClassInfo targetClass, MixinInfo.MixinMethodNode mixinMethod, ClassInfo.Method method) {
        MethodMapper methodMapper = targetClass.getMethodMapper();
        methodMapper.remapHandlerMethod(this.mixin, mixinMethod, method);
    }

    MixinTargetContext createContextFor(TargetClassContext target) {
        MixinTargetContext context = new MixinTargetContext(this.mixin, this.classNode, target);
        this.conform(target);
        this.attach(context);
        return context;
    }

    MixinPreProcessorStandard attach(MixinTargetContext context) {
        if (this.attached) {
            throw new IllegalStateException("Preprocessor was already attached");
        }
        this.attached = true;
        this.attachMethods(context);
        this.attachFields(context);
        this.transform(context);
        return this;
    }

    protected void attachMethods(MixinTargetContext context) {
        Iterator<MixinInfo.MixinMethodNode> iter = this.classNode.mixinMethods.iterator();
        while (iter.hasNext()) {
            MixinInfo.MixinMethodNode mixinMethod = iter.next();
            if (!this.validateMethod(context, mixinMethod)) {
                iter.remove();
                continue;
            }
            if (mixinMethod.isInjector()) continue;
            if (this.processShadowMethod(context, mixinMethod)) {
                iter.remove();
                context.addShadowMethod(mixinMethod);
                continue;
            }
            if (this.processOverwriteMethod(context, mixinMethod)) continue;
            if (this.processUniqueMethod(context, mixinMethod)) {
                iter.remove();
                continue;
            }
            this.processMethod(mixinMethod);
        }
    }

    protected boolean validateMethod(MixinTargetContext context, MixinInfo.MixinMethodNode mixinMethod) {
        return true;
    }

    protected boolean processShadowMethod(MixinTargetContext context, MixinInfo.MixinMethodNode mixinMethod) {
        return this.processSpecialMethod(context, mixinMethod, Shadow.class, false);
    }

    protected boolean processOverwriteMethod(MixinTargetContext context, MixinInfo.MixinMethodNode mixinMethod) {
        return this.processSpecialMethod(context, mixinMethod, Overwrite.class, true);
    }

    protected boolean processSpecialMethod(MixinTargetContext context, MixinInfo.MixinMethodNode mixinMethod, Class<? extends Annotation> type, boolean overwrite) {
        AnnotationNode annotation = ASMHelper.getVisibleAnnotation(mixinMethod, type);
        if (annotation == null) {
            return false;
        }
        if (this.mixin.isUnique() && overwrite) {
            throw new InvalidMixinException((IMixinInfo)this.mixin, "@Overwrite method " + mixinMethod.name + " found in a @Unique mixin");
        }
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethod, 10);
        MethodNode target = context.findMethod(mixinMethod, annotation);
        if (method.isUnique()) {
            throw new InvalidMixinException((IMixinInfo)this.mixin, "@" + ASMHelper.getSimpleName(type) + " method " + mixinMethod.name + " cannot be @Unique");
        }
        if (target == null) {
            if (overwrite) {
                return false;
            }
            target = context.findRemappedMethod(mixinMethod);
            if (target == null) {
                throw new InvalidMixinException((IMixinInfo)this.mixin, "@" + ASMHelper.getSimpleName(type) + " method " + mixinMethod.name + " was not located in the target class");
            }
            mixinMethod.name = method.renameTo(target.name);
        }
        if ("<init>".equals(target.name)) {
            throw new InvalidMixinException((IMixinInfo)this.mixin, "Nice try! Cannot alias a constructor!");
        }
        if (!target.name.equals(mixinMethod.name)) {
            if (!overwrite && (target.access & 2) == 0) {
                throw new InvalidMixinException((IMixinInfo)this.mixin, "Non-private method cannot be aliased. Found " + target.name);
            }
            mixinMethod.name = method.renameTo(target.name);
        }
        return true;
    }

    protected boolean processUniqueMethod(MixinTargetContext context, MixinInfo.MixinMethodNode mixinMethod) {
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethod, 10);
        if (method == null || !method.isUnique() && !this.mixin.isUnique()) {
            return false;
        }
        MethodNode target = context.findMethod(mixinMethod, null);
        if (target == null) {
            return false;
        }
        if ((mixinMethod.access & 6) != 0) {
            String uniqueName = context.getUniqueName(mixinMethod);
            logger.log(this.mixin.getLoggingLevel(), "Renaming @Unique method {}{} to {} in {}", new Object[]{mixinMethod.name, mixinMethod.desc, uniqueName, this.mixin});
            mixinMethod.name = method.renameTo(uniqueName);
            return false;
        }
        if (this.strictUnique) {
            throw new InvalidMixinException((IMixinInfo)this.mixin, "Method conflict, @Unique method " + mixinMethod.name + " in " + this.mixin + " cannot overwrite " + target.name + target.desc + " in " + context.getTarget());
        }
        logger.warn("Discarding @Unique public method {} in {} because it already exists in {}", new Object[]{mixinMethod.name, this.mixin, context.getTarget()});
        return true;
    }

    protected void processMethod(MixinInfo.MixinMethodNode mixinMethod) {
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethod);
        if (method == null) {
            return;
        }
        ClassInfo.Method parentMethod = this.mixin.getClassInfo().findMethodInHierarchy(mixinMethod, false);
        if (parentMethod != null && parentMethod.isRenamed()) {
            mixinMethod.name = method.renameTo(parentMethod.getName());
        }
    }

    protected void attachFields(MixinTargetContext context) {
        Iterator iter = this.classNode.fields.iterator();
        while (iter.hasNext()) {
            boolean isShadow;
            FieldNode mixinField = (FieldNode)iter.next();
            AnnotationNode shadow = ASMHelper.getVisibleAnnotation(mixinField, Shadow.class);
            boolean bl = isShadow = shadow != null;
            if (!this.validateField(context, mixinField, shadow)) {
                iter.remove();
                continue;
            }
            context.transformDescriptor(mixinField);
            ClassInfo.Field field = this.mixin.getClassInfo().findField(mixinField);
            if (field.isUnique() && isShadow) {
                throw new InvalidMixinException((IMixinInfo)this.mixin, "@Shadow field " + mixinField.name + " cannot be @Unique");
            }
            FieldNode target = context.findField(mixinField, shadow);
            if (target == null) {
                if (shadow == null) continue;
                target = context.findRemappedField(mixinField);
                if (target == null) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, "Shadow field " + mixinField.name + " was not located in the target class");
                }
                mixinField.name = field.renameTo(target.name);
            }
            if (field.isUnique()) {
                if ((mixinField.access & 6) != 0) {
                    String uniqueName = context.getUniqueName(mixinField);
                    logger.log(this.mixin.getLoggingLevel(), "Renaming @Unique field {}{} to {} in {}", new Object[]{mixinField.name, mixinField.desc, uniqueName, this.mixin});
                    mixinField.name = field.renameTo(uniqueName);
                    continue;
                }
                if (this.strictUnique) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, "Field conflict, @Unique field " + mixinField.name + " in " + this.mixin + " cannot overwrite " + target.name + target.desc + " in " + context.getTarget());
                }
                logger.warn("Discarding @Unique public field {} in {} because it already exists in {}. Note that declared FIELD INITIALISERS will NOT be removed!", new Object[]{mixinField.name, this.mixin, context.getTarget()});
                iter.remove();
                continue;
            }
            if (!target.desc.equals(mixinField.desc)) {
                throw new InvalidMixinException((IMixinInfo)this.mixin, "The field " + mixinField.name + " in the target class has a conflicting signature");
            }
            if (!target.name.equals(mixinField.name)) {
                if ((target.access & 2) == 0 && (target.access & 0x1000) == 0) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, "Non-private field cannot be aliased. Found " + target.name);
                }
                mixinField.name = field.renameTo(target.name);
            }
            iter.remove();
            if (!isShadow) continue;
            boolean isFinal = field.isDecoratedFinal();
            if (this.verboseLogging && ASMHelper.hasFlag(target, 16) != isFinal) {
                String message = isFinal ? "@Shadow field {}::{} is decorated with @Final but target is not final" : "@Shadow target {}::{} is final but shadow is not decorated with @Final";
                logger.warn(message, new Object[]{this.mixin, mixinField.name});
            }
            context.addShadowField(mixinField, field);
        }
    }

    protected boolean validateField(MixinTargetContext context, FieldNode field, AnnotationNode shadow) {
        if (ASMHelper.hasFlag(field, 8) && !ASMHelper.hasFlag(field, 2) && !ASMHelper.hasFlag(field, 4096) && shadow == null) {
            throw new InvalidMixinException((IReferenceMapperContext)context, String.format("Mixin %s contains non-private static field %s:%s", context, field.name, field.desc));
        }
        String prefix = (String)ASMHelper.getAnnotationValue(shadow, "prefix", Shadow.class);
        if (field.name.startsWith(prefix)) {
            throw new InvalidMixinException((IReferenceMapperContext)context, String.format("@Shadow field %s.%s has a shadow prefix. This is not allowed.", context, field.name));
        }
        if ("super$".equals(field.name)) {
            if (field.access != 2) {
                throw new InvalidMixinException((IMixinInfo)this.mixin, "Imaginary super field " + context + "." + field.name + " must be private and non-final");
            }
            if (!field.desc.equals("L" + this.mixin.getClassRef() + ";")) {
                throw new InvalidMixinException((IMixinInfo)this.mixin, "Imaginary super field " + context + "." + field.name + " must have the same type as the parent mixin");
            }
            return false;
        }
        return true;
    }

    protected void transform(MixinTargetContext context) {
        for (MethodNode mixinMethod : this.classNode.methods) {
            ListIterator<AbstractInsnNode> iter = mixinMethod.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode insn = (AbstractInsnNode)iter.next();
                if (insn instanceof MethodInsnNode) {
                    MethodInsnNode methodNode = (MethodInsnNode)insn;
                    ClassInfo.Method method = ClassInfo.forName(methodNode.owner).findMethodInHierarchy(methodNode, true, 2);
                    if (method == null || !method.isRenamed()) continue;
                    methodNode.name = method.getName();
                    continue;
                }
                if (!(insn instanceof FieldInsnNode)) continue;
                FieldInsnNode fieldNode = (FieldInsnNode)insn;
                ClassInfo.Field field = ClassInfo.forName(fieldNode.owner).findField(fieldNode, 2);
                if (field == null || !field.isRenamed()) continue;
                fieldNode.name = field.getName();
            }
        }
    }
}

