/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinErrorHandler;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.throwables.ClassAlreadyLoadedException;
import org.spongepowered.asm.mixin.throwables.MixinApplyError;
import org.spongepowered.asm.mixin.throwables.MixinException;
import org.spongepowered.asm.mixin.throwables.MixinPrepareError;
import org.spongepowered.asm.mixin.transformer.Config;
import org.spongepowered.asm.mixin.transformer.IMixinTransformerModule;
import org.spongepowered.asm.mixin.transformer.MixinConfig;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinTransformerModuleCheckClass;
import org.spongepowered.asm.mixin.transformer.MixinTransformerModuleInterfaceChecker;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.TreeInfo;
import org.spongepowered.asm.mixin.transformer.debug.IDecompiler;
import org.spongepowered.asm.mixin.transformer.debug.IHotSwap;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTransformerError;
import org.spongepowered.asm.transformers.TreeTransformer;
import org.spongepowered.asm.util.PrettyPrinter;

public class MixinTransformer
extends TreeTransformer {
    static final File DEBUG_OUTPUT = new File(".mixin.out");
    private final Logger logger = LogManager.getLogger((String)"mixin");
    private final List<MixinConfig> configs = new ArrayList<MixinConfig>();
    private final List<MixinConfig> pendingConfigs = new ArrayList<MixinConfig>();
    private final List<IMixinTransformerModule> modules = new ArrayList<IMixinTransformerModule>();
    private MixinEnvironment currentEnvironment;
    private final ReEntranceState lock = new ReEntranceState(1);
    private final String sessionId = UUID.randomUUID().toString();
    private Level verboseLoggingLevel = Level.DEBUG;
    private boolean errorState = false;
    private final File classExportDir = new File(DEBUG_OUTPUT, "class");
    private final IDecompiler decompiler;
    private final IHotSwap hotSwapper;

    MixinTransformer() {
        MixinEnvironment environment = MixinEnvironment.getCurrentEnvironment();
        Object globalMixinTransformer = environment.getActiveTransformer();
        if (globalMixinTransformer instanceof IClassTransformer) {
            throw new MixinException("Terminating MixinTransformer instance " + this);
        }
        environment.setActiveTransformer(this);
        TreeInfo.setLock(this.lock);
        this.decompiler = this.initDecompiler(new File(DEBUG_OUTPUT, "java"));
        this.hotSwapper = this.initHotSwapper();
        try {
            FileUtils.deleteDirectory((File)this.classExportDir);
        }
        catch (IOException ex) {
            this.logger.warn("Error cleaning class output directory: {}", new Object[]{ex.getMessage()});
        }
    }

    private IDecompiler initDecompiler(File outputPath) {
        MixinEnvironment env = MixinEnvironment.getCurrentEnvironment();
        if (!env.getOption(MixinEnvironment.Option.DEBUG_EXPORT_DECOMPILE)) {
            return null;
        }
        try {
            boolean as = env.getOption(MixinEnvironment.Option.DEBUG_EXPORT_DECOMPILE_THREADED);
            this.logger.info("Attempting to load Fernflower decompiler{}", new Object[]{as ? " (Threaded mode)" : ""});
            Class<?> clazz = Class.forName("org.spongepowered.asm.mixin.transformer.debug.RuntimeDecompiler" + (as ? "Async" : ""));
            Constructor<?> ctor = clazz.getDeclaredConstructor(File.class);
            IDecompiler decompiler = (IDecompiler)ctor.newInstance(outputPath);
            this.logger.info("Fernflower decompiler was successfully initialised, exported classes will be decompiled{}", new Object[]{as ? " in a separate thread" : ""});
            return decompiler;
        }
        catch (Throwable th) {
            this.logger.info("Fernflower could not be loaded, exported classes will not be decompiled. {}: {}", new Object[]{th.getClass().getSimpleName(), th.getMessage()});
            return null;
        }
    }

    private IHotSwap initHotSwapper() {
        if (!MixinEnvironment.getCurrentEnvironment().getOption(MixinEnvironment.Option.HOT_SWAP)) {
            return null;
        }
        try {
            this.logger.info("Attempting to load Hot-Swap agent");
            Class<?> clazz = Class.forName("org.spongepowered.tools.agent.MixinAgent");
            Constructor<?> ctor = clazz.getDeclaredConstructor(MixinTransformer.class);
            return (IHotSwap)ctor.newInstance(this);
        }
        catch (Throwable th) {
            this.logger.info("Hot-swap agent could not be loaded, hot swapping of mixins won't work. {}: {}", new Object[]{th.getClass().getSimpleName(), th.getMessage()});
            return null;
        }
    }

    public void audit() {
        HashSet<String> unhandled = new HashSet<String>();
        for (MixinConfig config : this.configs) {
            unhandled.addAll(config.getUnhandledTargets());
        }
        Logger auditLogger = LogManager.getLogger((String)"mixin/audit");
        for (String target : unhandled) {
            try {
                auditLogger.info("Force-loading class {}", new Object[]{target});
                Class.forName(target, true, (ClassLoader)Launch.classLoader);
            }
            catch (ClassNotFoundException ex) {
                auditLogger.error("Could not force-load " + target, (Throwable)ex);
            }
        }
        for (MixinConfig config : this.configs) {
            for (String target : config.getUnhandledTargets()) {
                ClassAlreadyLoadedException ex = new ClassAlreadyLoadedException(target + " was already classloaded");
                auditLogger.error("Could not force-load " + target, (Throwable)ex);
            }
        }
    }

    public synchronized byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null || transformedName == null || this.errorState) {
            return basicClass;
        }
        boolean locked = this.lock.push().check();
        MixinEnvironment environment = MixinEnvironment.getCurrentEnvironment();
        if (this.currentEnvironment != environment && !locked) {
            try {
                this.select(environment);
            }
            catch (Exception ex) {
                this.lock.pop();
                throw new MixinException(ex);
            }
        }
        try {
            TreeSet<MixinInfo> mixins = null;
            boolean invalidRef = false;
            for (MixinConfig config : this.configs) {
                if (config.packageMatch(transformedName)) {
                    if (config.canPassThrough(transformedName)) {
                        byte[] byArray = this.passThrough(name, transformedName, basicClass);
                        return byArray;
                    }
                    invalidRef = true;
                    continue;
                }
                if (!config.hasMixinsFor(transformedName)) continue;
                if (mixins == null) {
                    mixins = new TreeSet<MixinInfo>();
                }
                mixins.addAll(config.getMixinsFor(transformedName));
            }
            if (invalidRef) {
                throw new NoClassDefFoundError(String.format("%s is a mixin class and cannot be referenced directly", transformedName));
            }
            if (mixins != null) {
                if (locked) {
                    this.logger.warn("Re-entrance detected, this will cause serious problems.", (Throwable)new MixinException());
                    throw new MixinApplyError("Re-entrance error.");
                }
                if (this.hotSwapper != null) {
                    this.hotSwapper.registerTargetClass(transformedName, basicClass);
                }
                try {
                    ClassNode targetClassNode = this.readClass(basicClass, true);
                    TargetClassContext context = new TargetClassContext(this.sessionId, transformedName, targetClassNode, mixins);
                    basicClass = this.applyMixins(context);
                }
                catch (InvalidMixinException th) {
                    this.dumpClassOnFailure(transformedName, basicClass, environment);
                    this.handleMixinApplyError(transformedName, th, environment);
                }
            }
            byte[] byArray = basicClass;
            return byArray;
        }
        catch (Throwable th) {
            th.printStackTrace();
            this.dumpClassOnFailure(transformedName, basicClass, environment);
            throw new MixinTransformerError("An unexpected critical error was encountered", th);
        }
        finally {
            this.lock.pop();
        }
    }

    public List<String> reload(String mixinClass, byte[] bytes) {
        if (this.lock.getDepth() > 0) {
            throw new MixinApplyError("Cannot reload mixin if re-entrant lock entered");
        }
        ArrayList<String> targets = new ArrayList<String>();
        for (MixinConfig config : this.configs) {
            targets.addAll(config.reloadMixin(mixinClass, bytes));
        }
        return targets;
    }

    private void select(MixinEnvironment environment) {
        this.verboseLoggingLevel = environment.getOption(MixinEnvironment.Option.DEBUG_VERBOSE) ? Level.INFO : Level.DEBUG;
        this.logger.log(this.verboseLoggingLevel, "Preparing mixins for {}", new Object[]{environment});
        long startTime = System.currentTimeMillis();
        this.selectConfigs(environment);
        this.selectModules(environment);
        int totalMixins = this.prepareConfigs(environment);
        this.currentEnvironment = environment;
        double elapsedTime = (double)(System.currentTimeMillis() - startTime) * 0.001;
        if (elapsedTime > 0.25) {
            String elapsed = new DecimalFormat("###0.000").format(elapsedTime);
            String perMixinTime = new DecimalFormat("###0.0").format(elapsedTime / (double)totalMixins * 1000.0);
            this.logger.log(this.verboseLoggingLevel, "Prepared {} mixins in {} sec ({} msec avg.)", new Object[]{totalMixins, elapsed, perMixinTime});
        }
    }

    private void selectConfigs(MixinEnvironment environment) {
        Iterator<Config> iter = Mixins.getConfigs().iterator();
        while (iter.hasNext()) {
            Config handle = iter.next();
            try {
                MixinConfig config = handle.get();
                if (!config.select(environment)) continue;
                iter.remove();
                this.logger.log(this.verboseLoggingLevel, "Selecting config {}", new Object[]{config});
                config.onSelect();
                this.pendingConfigs.add(config);
            }
            catch (Exception ex) {
                this.logger.warn(String.format("Failed to select mixin config: %s", handle), (Throwable)ex);
            }
        }
        Collections.sort(this.pendingConfigs);
    }

    private void selectModules(MixinEnvironment environment) {
        this.modules.clear();
        if (environment.getOption(MixinEnvironment.Option.DEBUG_VERIFY)) {
            this.modules.add(new MixinTransformerModuleCheckClass());
        }
        if (environment.getOption(MixinEnvironment.Option.CHECK_IMPLEMENTS)) {
            this.modules.add(new MixinTransformerModuleInterfaceChecker());
        }
    }

    private int prepareConfigs(MixinEnvironment environment) {
        int totalMixins = 0;
        for (MixinConfig config : this.pendingConfigs) {
            try {
                this.logger.log(this.verboseLoggingLevel, "Preparing {} ({})", new Object[]{config, config.getDeclaredMixinCount()});
                config.prepare(this.hotSwapper);
                totalMixins += config.getMixinCount();
            }
            catch (InvalidMixinException ex) {
                this.handleMixinPrepareError(config, ex, environment);
            }
            catch (Exception ex) {
                this.logger.error("Error encountered whilst initialising mixin config '" + config.getName() + "': " + ex.getMessage(), (Throwable)ex);
            }
        }
        for (MixinConfig config : this.pendingConfigs) {
            IMixinConfigPlugin plugin = config.getPlugin();
            if (plugin == null) continue;
            HashSet<String> otherTargets = new HashSet<String>();
            for (MixinConfig otherConfig : this.pendingConfigs) {
                if (otherConfig.equals(config)) continue;
                otherTargets.addAll(otherConfig.getTargets());
            }
            plugin.acceptTargets(config.getTargets(), Collections.unmodifiableSet(otherTargets));
        }
        for (MixinConfig config : this.pendingConfigs) {
            try {
                config.postInitialise(this.hotSwapper);
            }
            catch (InvalidMixinException ex) {
                this.handleMixinPrepareError(config, ex, environment);
            }
            catch (Exception ex) {
                this.logger.error("Error encountered during mixin config postInit step'" + config.getName() + "': " + ex.getMessage(), (Throwable)ex);
            }
        }
        this.configs.addAll(this.pendingConfigs);
        Collections.sort(this.configs);
        this.pendingConfigs.clear();
        return totalMixins;
    }

    private byte[] passThrough(String name, String transformedName, byte[] basicClass) {
        ClassNode passThroughClass = this.readClass(basicClass, true);
        passThroughClass.access |= 1;
        for (FieldNode field : passThroughClass.fields) {
            if ((field.access & 6) != 0) continue;
            field.access |= 1;
        }
        for (MethodNode method : passThroughClass.methods) {
            if ((method.access & 6) != 0) continue;
            method.access |= 1;
        }
        return this.writeClass(transformedName, passThroughClass, false);
    }

    private byte[] applyMixins(TargetClassContext context) {
        block2: {
            this.preApply(context);
            this.apply(context);
            try {
                this.postApply(context);
            }
            catch (MixinTransformerModuleCheckClass.ValidationFailedException ex) {
                this.logger.info(ex.getMessage());
                if (!context.isExportForced() && !MixinEnvironment.getCurrentEnvironment().getOption(MixinEnvironment.Option.DEBUG_EXPORT)) break block2;
                this.writeClass(context);
            }
        }
        return this.writeClass(context);
    }

    private void preApply(TargetClassContext context) {
        for (IMixinTransformerModule module : this.modules) {
            module.preApply(context);
        }
    }

    private void apply(TargetClassContext context) {
        context.applyMixins();
    }

    private void postApply(TargetClassContext context) {
        for (IMixinTransformerModule module : this.modules) {
            module.postApply(context);
        }
    }

    private void handleMixinPrepareError(MixinConfig config, InvalidMixinException ex, MixinEnvironment environment) throws MixinPrepareError {
        this.handleMixinError(config.getName(), ex, environment, ErrorPhase.PREPARE);
    }

    private void handleMixinApplyError(String targetClass, InvalidMixinException ex, MixinEnvironment environment) throws MixinApplyError {
        this.handleMixinError(targetClass, ex, environment, ErrorPhase.APPLY);
    }

    private void handleMixinError(String context, InvalidMixinException ex, MixinEnvironment environment, ErrorPhase errorPhase) throws Error {
        IMixinErrorHandler.ErrorAction action;
        this.errorState = true;
        IMixinInfo mixin = ex.getMixin();
        if (mixin == null) {
            this.logger.error("InvalidMixinException has no mixin!", (Throwable)ex);
            throw ex;
        }
        IMixinConfig config = mixin.getConfig();
        MixinEnvironment.Phase phase = mixin.getPhase();
        IMixinErrorHandler.ErrorAction errorAction = action = config.isRequired() ? IMixinErrorHandler.ErrorAction.ERROR : IMixinErrorHandler.ErrorAction.WARN;
        if (environment.getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) {
            new PrettyPrinter().add("Invalid Mixin").centre().hr('-').kvWidth(10).kv("Action", errorPhase.name()).kv("Mixin", mixin.getClassName()).kv("Config", config.getName()).kv("Phase", phase).hr('-').add("    %s", ex.getClass().getName()).hr('-').addWrapped("    %s", ex.getMessage()).hr('-').add(ex.getStackTrace(), 8).trace(action.logLevel);
        }
        for (IMixinErrorHandler handler : this.getErrorHandlers(mixin.getPhase())) {
            IMixinErrorHandler.ErrorAction newAction = errorPhase.onError(handler, context, ex, mixin, action);
            if (newAction == null) continue;
            action = newAction;
        }
        this.logger.log(action.logLevel, errorPhase.getLogMessage(context, ex, mixin), (Throwable)ex);
        this.errorState = false;
        if (action == IMixinErrorHandler.ErrorAction.ERROR) {
            throw new MixinApplyError(errorPhase.getErrorMessage(mixin, config, phase), ex);
        }
    }

    private List<IMixinErrorHandler> getErrorHandlers(MixinEnvironment.Phase phase) {
        ArrayList<IMixinErrorHandler> handlers = new ArrayList<IMixinErrorHandler>();
        for (String handlerClassName : Mixins.getErrorHandlerClasses()) {
            try {
                this.logger.info("Instancing error handler class {}", new Object[]{handlerClassName});
                Class<?> handlerClass = Class.forName(handlerClassName, true, (ClassLoader)Launch.classLoader);
                IMixinErrorHandler handler = (IMixinErrorHandler)handlerClass.newInstance();
                if (handler == null) continue;
                handlers.add(handler);
            }
            catch (Throwable th) {}
        }
        return handlers;
    }

    private String prepareFilter(String filter) {
        filter = "^\\Q" + filter.replace("**", "\u0081").replace("*", "\u0082").replace("?", "\u0083") + "\\E$";
        return filter.replace("\u0081", "\\E.*\\Q").replace("\u0082", "\\E[^\\.]+\\Q").replace("\u0083", "\\E.\\Q").replace("\\Q\\E", "");
    }

    private boolean applyFilter(String filter, String subject) {
        return Pattern.compile(this.prepareFilter(filter), 2).matcher(subject).matches();
    }

    private byte[] writeClass(TargetClassContext context) {
        return this.writeClass(context.getClassName(), context.getClassNode(), context.isExportForced());
    }

    private byte[] writeClass(String transformedName, ClassNode targetClass, boolean forceExport) {
        byte[] bytes = this.writeClass(targetClass);
        MixinEnvironment environment = MixinEnvironment.getCurrentEnvironment();
        if (forceExport || environment.getOption(MixinEnvironment.Option.DEBUG_EXPORT)) {
            String filter = environment.getOptionValue(MixinEnvironment.Option.DEBUG_EXPORT_FILTER);
            if (forceExport || filter == null || this.applyFilter(filter, transformedName)) {
                File outputFile = this.dumpClass(transformedName.replace('.', '/'), bytes);
                if (this.decompiler != null) {
                    this.decompiler.decompile(outputFile);
                }
            }
        }
        return bytes;
    }

    private void dumpClassOnFailure(String className, byte[] bytes, MixinEnvironment env) {
        if (env.getOption(MixinEnvironment.Option.DUMP_TARGET_ON_FAILURE)) {
            this.dumpClass(className.replace('.', '/') + ".target", bytes);
        }
    }

    private File dumpClass(String fileName, byte[] bytes) {
        File outputFile = new File(this.classExportDir, fileName + ".class");
        try {
            FileUtils.writeByteArrayToFile((File)outputFile, (byte[])bytes);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return outputFile;
    }

    class ReEntranceState {
        private final int maxDepth;
        private int depth = 0;
        private boolean semaphore = false;

        public ReEntranceState(int maxDepth) {
            this.maxDepth = maxDepth;
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }

        public int getDepth() {
            return this.depth;
        }

        ReEntranceState push() {
            ++this.depth;
            this.checkAndSet();
            return this;
        }

        ReEntranceState pop() {
            if (this.depth == 0) {
                throw new IllegalStateException("ReEntranceState pop() with zero depth");
            }
            --this.depth;
            return this;
        }

        boolean check() {
            return this.depth > this.maxDepth;
        }

        boolean checkAndSet() {
            return this.semaphore |= this.check();
        }

        ReEntranceState set() {
            this.semaphore = true;
            return this;
        }

        boolean isSet() {
            return this.semaphore;
        }

        ReEntranceState clear() {
            this.semaphore = false;
            return this;
        }
    }

    public static class Proxy
    implements IClassTransformer {
        private static List<Proxy> proxies = new ArrayList<Proxy>();
        private static MixinTransformer transformer = new MixinTransformer();
        private boolean isActive = true;

        public Proxy() {
            for (Proxy hook : proxies) {
                hook.isActive = false;
            }
            proxies.add(this);
            LogManager.getLogger((String)"mixin").debug("Adding new mixin transformer proxy #{}", new Object[]{proxies.size()});
        }

        public byte[] transform(String name, String transformedName, byte[] basicClass) {
            if (this.isActive) {
                return transformer.transform(name, transformedName, basicClass);
            }
            return basicClass;
        }
    }

    static enum ErrorPhase {
        PREPARE{

            @Override
            IMixinErrorHandler.ErrorAction onError(IMixinErrorHandler handler, String context, InvalidMixinException ex, IMixinInfo mixin, IMixinErrorHandler.ErrorAction action) {
                try {
                    return handler.onPrepareError(mixin.getConfig(), ex, mixin, action);
                }
                catch (AbstractMethodError ame) {
                    return action;
                }
            }

            @Override
            protected String getContext(IMixinInfo mixin, String context) {
                return String.format("preparing %s in %s", mixin.getName(), context);
            }
        }
        ,
        APPLY{

            @Override
            IMixinErrorHandler.ErrorAction onError(IMixinErrorHandler handler, String context, InvalidMixinException ex, IMixinInfo mixin, IMixinErrorHandler.ErrorAction action) {
                try {
                    return handler.onApplyError(context, ex, mixin, action);
                }
                catch (AbstractMethodError ame) {
                    return action;
                }
            }

            @Override
            protected String getContext(IMixinInfo mixin, String context) {
                return String.format("%s -> %s", mixin, context);
            }
        };

        private final String text = this.name().toLowerCase();

        abstract IMixinErrorHandler.ErrorAction onError(IMixinErrorHandler var1, String var2, InvalidMixinException var3, IMixinInfo var4, IMixinErrorHandler.ErrorAction var5);

        protected abstract String getContext(IMixinInfo var1, String var2);

        public String getLogMessage(String context, InvalidMixinException ex, IMixinInfo mixin) {
            return String.format("Mixin %s failed %s: %s %s", this.text, this.getContext(mixin, context), ex.getClass().getName(), ex.getMessage());
        }

        public String getErrorMessage(IMixinInfo mixin, IMixinConfig config, MixinEnvironment.Phase phase) {
            return String.format("Mixin [%s] from phase [%s] in config [%s] FAILED during %s", mixin, phase, config, this.name());
        }
    }
}

