/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.io.OutputStream;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinApplicatorInterface;
import org.spongepowered.asm.mixin.transformer.MixinApplicatorStandard;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.util.ASMHelper;

class TargetClassContext {
    private final String sessionId;
    private final String className;
    private final ClassNode classNode;
    private final ClassInfo classInfo;
    private final SortedSet<MixinInfo> mixins;
    private final Map<String, Target> targetMethods = new HashMap<String, Target>();
    private int nextUniqueMethodIndex;
    private int nextUniqueFieldIndex;
    private boolean applied;
    private boolean forceExport;

    TargetClassContext(String sessionId, String name, ClassNode classNode, SortedSet<MixinInfo> mixins) {
        this.sessionId = sessionId;
        this.className = name;
        this.classNode = classNode;
        this.classInfo = ClassInfo.fromClassNode(classNode);
        this.mixins = mixins;
    }

    public String toString() {
        return this.className;
    }

    public boolean isApplied() {
        return this.applied;
    }

    public boolean isExportForced() {
        return this.forceExport;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getName() {
        return this.classNode.name;
    }

    public String getClassName() {
        return this.className;
    }

    public ClassNode getClassNode() {
        return this.classNode;
    }

    public List<MethodNode> getMethods() {
        return this.classNode.methods;
    }

    public List<FieldNode> getFields() {
        return this.classNode.fields;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public SortedSet<MixinInfo> getMixins() {
        return this.mixins;
    }

    MethodNode findAliasedMethod(Deque<String> aliases, String desc) {
        String alias = aliases.poll();
        if (alias == null) {
            return null;
        }
        for (MethodNode target : this.classNode.methods) {
            if (!target.name.equals(alias) || !target.desc.equals(desc)) continue;
            return target;
        }
        return this.findAliasedMethod(aliases, desc);
    }

    FieldNode findAliasedField(Deque<String> aliases, String desc) {
        String alias = aliases.poll();
        if (alias == null) {
            return null;
        }
        for (FieldNode target : this.classNode.fields) {
            if (!target.name.equals(alias) || !target.desc.equals(desc)) continue;
            return target;
        }
        return this.findAliasedField(aliases, desc);
    }

    public Target getTargetMethod(MethodNode method) {
        if (!this.classNode.methods.contains(method)) {
            throw new IllegalArgumentException("Invalid target method supplied to getTargetMethod()");
        }
        String targetName = method.name + method.desc;
        Target target = this.targetMethods.get(targetName);
        if (target == null) {
            target = new Target(this.classNode, method);
            this.targetMethods.put(targetName, target);
        }
        return target;
    }

    public String getUniqueName(MethodNode method) {
        String uniqueIndex = Integer.toHexString(this.nextUniqueMethodIndex++);
        return String.format("md%s$%s$%s", this.sessionId.substring(30), method.name, uniqueIndex);
    }

    public String getUniqueName(FieldNode field) {
        String uniqueIndex = Integer.toHexString(this.nextUniqueFieldIndex++);
        return String.format("fd%s$%s$%s", this.sessionId.substring(30), field.name, uniqueIndex);
    }

    public void applyMixins() {
        if (this.applied) {
            throw new IllegalStateException("Mixins already applied to target class " + this.className);
        }
        this.applied = true;
        MixinApplicatorStandard applicator = this.createApplicator();
        applicator.apply(this.mixins);
    }

    private MixinApplicatorStandard createApplicator() {
        if (this.classInfo.isInterface()) {
            return new MixinApplicatorInterface(this);
        }
        return new MixinApplicatorStandard(this);
    }

    public void processDebugTasks() {
        if (!MixinEnvironment.getCurrentEnvironment().getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) {
            return;
        }
        AnnotationNode classDebugAnnotation = ASMHelper.getVisibleAnnotation(this.classNode, Debug.class);
        if (classDebugAnnotation != null) {
            this.forceExport = Boolean.TRUE.equals(ASMHelper.getAnnotationValue(classDebugAnnotation, "export"));
            if (Boolean.TRUE.equals(ASMHelper.getAnnotationValue(classDebugAnnotation, "print"))) {
                ASMHelper.textify(this.classNode, (OutputStream)System.err);
            }
        }
        for (MethodNode method : this.classNode.methods) {
            AnnotationNode methodDebugAnnotation = ASMHelper.getVisibleAnnotation(method, Debug.class);
            if (methodDebugAnnotation == null || !Boolean.TRUE.equals(ASMHelper.getAnnotationValue(methodDebugAnnotation, "print"))) continue;
            ASMHelper.textify(method, (OutputStream)System.err);
        }
    }
}

