/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.tools.MirrorUtils;
import org.spongepowered.tools.obfuscation.AnnotatedMixinInjectorHandler;
import org.spongepowered.tools.obfuscation.AnnotatedMixinOverwriteHandler;
import org.spongepowered.tools.obfuscation.AnnotatedMixinShadowHandler;
import org.spongepowered.tools.obfuscation.AnnotatedMixins;
import org.spongepowered.tools.obfuscation.ObfuscationData;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.TypeHandle;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IMixinValidator;
import org.spongepowered.tools.obfuscation.interfaces.IObfuscationManager;
import org.spongepowered.tools.obfuscation.interfaces.ITypeHandleProvider;
import org.spongepowered.tools.obfuscation.struct.Message;

class AnnotatedMixin {
    private final AnnotationMirror annotation;
    private final Messager messager;
    private final ITypeHandleProvider typeProvider;
    private final IObfuscationManager obf;
    private final TypeElement mixin;
    private final TypeHandle handle;
    private final List<TypeHandle> targets = new ArrayList<TypeHandle>();
    private final String targetRef;
    private final TypeHandle targetType;
    private final String classRef;
    private final boolean remap;
    private final Map<ObfuscationType, Set<String>> fieldMappings = new HashMap<ObfuscationType, Set<String>>();
    private final Map<ObfuscationType, Set<String>> methodMappings = new HashMap<ObfuscationType, Set<String>>();
    private final AnnotatedMixinOverwriteHandler overwrites;
    private final AnnotatedMixinShadowHandler shadows;
    private final AnnotatedMixinInjectorHandler injectors;

    public AnnotatedMixin(IMixinAnnotationProcessor ap, TypeElement type) {
        this.annotation = MirrorUtils.getAnnotation(type, Mixin.class);
        this.typeProvider = ap.getTypeProvider();
        this.obf = ap.getObfuscationManager();
        this.messager = ap;
        this.mixin = type;
        this.handle = new TypeHandle(type);
        this.classRef = type.getQualifiedName().toString().replace('.', '/');
        TypeHandle primaryTarget = this.initTargets();
        if (primaryTarget != null) {
            this.targetRef = primaryTarget.getName();
            this.targetType = primaryTarget;
        } else {
            this.targetRef = null;
            this.targetType = null;
        }
        this.remap = AnnotatedMixins.getRemapValue(this.annotation) && this.targets.size() > 0;
        for (ObfuscationType obfType : ObfuscationType.values()) {
            this.fieldMappings.put(obfType, new LinkedHashSet());
            this.methodMappings.put(obfType, new LinkedHashSet());
        }
        this.overwrites = new AnnotatedMixinOverwriteHandler(ap, this);
        this.shadows = new AnnotatedMixinShadowHandler(ap, this);
        this.injectors = new AnnotatedMixinInjectorHandler(ap, this);
    }

    AnnotatedMixin runValidators(IMixinValidator.ValidationPass pass, Collection<IMixinValidator> validators) {
        for (IMixinValidator validator : validators) {
            if (!validator.validate(pass, this.mixin, this.annotation, this.targets)) break;
        }
        return this;
    }

    private TypeHandle initTargets() {
        TypeHandle type;
        TypeHandle primaryTarget = null;
        try {
            List<AnnotationValue> publicTargets = MirrorUtils.getAnnotationValue(this.annotation, "value", Collections.emptyList());
            for (TypeMirror target : MirrorUtils.unfold(publicTargets)) {
                type = new TypeHandle((DeclaredType)target);
                if (this.targets.contains(type)) continue;
                this.addTarget(type);
                if (primaryTarget != null) continue;
                primaryTarget = type;
            }
        }
        catch (Exception ex) {
            this.printMessage(Diagnostic.Kind.WARNING, "Error processing public targets: " + ex.getClass().getName() + ": " + ex.getMessage(), this);
        }
        try {
            List<AnnotationValue> privateTargets = MirrorUtils.getAnnotationValue(this.annotation, "targets", Collections.emptyList());
            for (String privateTarget : MirrorUtils.unfold(privateTargets)) {
                type = this.typeProvider.getTypeHandle(privateTarget);
                if (this.targets.contains(type)) continue;
                if (type == null) {
                    this.printMessage(Diagnostic.Kind.ERROR, "Mixin target " + privateTarget + " could not be found", this);
                    return null;
                }
                if (type.isPublic()) {
                    this.printMessage(Diagnostic.Kind.WARNING, "Mixin target " + privateTarget + " is public and must be specified in value", this);
                    return null;
                }
                this.addSoftTarget(type, privateTarget);
                if (primaryTarget != null) continue;
                primaryTarget = type;
            }
        }
        catch (Exception ex) {
            this.printMessage(Diagnostic.Kind.WARNING, "Error processing private targets: " + ex.getClass().getName() + ": " + ex.getMessage(), this);
        }
        if (primaryTarget == null) {
            this.printMessage(Diagnostic.Kind.ERROR, "Mixin has no targets", this);
        }
        return primaryTarget;
    }

    private void printMessage(Diagnostic.Kind kind, CharSequence msg, AnnotatedMixin mixin) {
        this.messager.printMessage(kind, msg, this.mixin, this.annotation);
    }

    private void addSoftTarget(TypeHandle type, String reference) {
        ObfuscationData<String> obfClassData = this.obf.getObfClass(type);
        if (!obfClassData.isEmpty()) {
            this.obf.addClassMapping(this.classRef, reference, obfClassData);
        }
        this.addTarget(type);
    }

    private void addTarget(TypeHandle type) {
        this.targets.add(type);
    }

    public String toString() {
        return this.mixin.getSimpleName().toString();
    }

    public AnnotationMirror getAnnotation() {
        return this.annotation;
    }

    public TypeElement getMixin() {
        return this.mixin;
    }

    public TypeHandle getHandle() {
        return this.handle;
    }

    public String getClassRef() {
        return this.classRef;
    }

    public boolean isInterface() {
        return this.mixin.getKind() == ElementKind.INTERFACE;
    }

    public String getPrimaryTargetRef() {
        return this.targetRef;
    }

    public TypeHandle getPrimaryTarget() {
        return this.targetType;
    }

    public List<TypeHandle> getTargets() {
        return this.targets;
    }

    public boolean remap() {
        return this.remap;
    }

    public Set<String> getFieldMappings(ObfuscationType type) {
        return this.fieldMappings.get((Object)type);
    }

    public Set<String> getMethodMappings(ObfuscationType type) {
        return this.methodMappings.get((Object)type);
    }

    public void clear() {
        this.fieldMappings.clear();
        this.methodMappings.clear();
    }

    public void registerOverwrite(ExecutableElement method, AnnotationMirror overwrite) {
        this.overwrites.registerOverwrite(method, overwrite);
    }

    public void registerShadow(VariableElement field, AnnotationMirror shadow, boolean shouldRemap) {
        this.shadows.registerShadow(field, shadow, shouldRemap);
    }

    public void registerShadow(ExecutableElement method, AnnotationMirror shadow, boolean shouldRemap) {
        this.shadows.registerShadow(method, shadow, shouldRemap);
    }

    public Message registerInjector(ExecutableElement method, AnnotationMirror inject, boolean remap) {
        return this.injectors.registerInjector(method, inject, remap);
    }

    public int registerInjectionPoint(ExecutableElement element, AnnotationMirror inject, AnnotationMirror at) {
        return this.injectors.registerInjectionPoint(element, inject, at);
    }

    void addFieldMapping(ObfuscationType type, String mapping) {
        this.fieldMappings.get((Object)type).add(mapping);
    }

    void addMethodMapping(ObfuscationType type, String mapping) {
        this.methodMappings.get((Object)type).add(mapping);
    }
}

