/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.launch;

import java.util.List;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.Blackboard;
import org.spongepowered.asm.launch.MixinInitialisationError;
import org.spongepowered.asm.mixin.MixinEnvironment;

public abstract class MixinBootstrap {
    public static final String VERSION = "0.5.3";
    private static final String LAUNCH_PACKAGE = "org.spongepowered.asm.launch.";
    private static final String MIXIN_PACKAGE = "org.spongepowered.asm.mixin.";
    private static final String MIXIN_UTIL_PACKAGE = "org.spongepowered.asm.util.";
    private static final String ASM_PACKAGE = "org.spongepowered.asm.lib.";
    private static final String TRANSFORMER_PROXY_CLASS = "org.spongepowered.asm.mixin.transformer.MixinTransformer$Proxy";
    private static final Logger logger = LogManager.getLogger((String)"mixin");
    private static boolean initialised = false;
    private static boolean injectStateTweaker = true;

    private MixinBootstrap() {
    }

    public static void addProxy() {
        Launch.classLoader.registerTransformer(TRANSFORMER_PROXY_CLASS);
    }

    public static void init() {
        if (!MixinBootstrap.preInit()) {
            return;
        }
        MixinBootstrap.register();
    }

    static boolean preInit() {
        Object registeredVersion = Blackboard.get("mixin.initialised");
        if (registeredVersion != null) {
            if (!registeredVersion.equals(VERSION)) {
                throw new MixinInitialisationError("Mixin subsystem version " + registeredVersion + " was already initialised. Cannot bootstrap version " + VERSION);
            }
            return false;
        }
        Blackboard.put("mixin.initialised", VERSION);
        if (!initialised) {
            initialised = true;
            if (MixinBootstrap.findInStackTrace(Launch.class.getName(), "launch") > 132) {
                logger.error("Initialising mixin subsystem after game pre-init phase! Some mixins may be skipped.");
                MixinEnvironment.init(MixinEnvironment.Phase.DEFAULT);
                injectStateTweaker = false;
            } else {
                MixinEnvironment.init(MixinEnvironment.Phase.PREINIT);
            }
            MixinBootstrap.addProxy();
        }
        return true;
    }

    static void register() {
        if (!initialised) {
            throw new IllegalStateException("MixinBootstrap.register() called before MixinBootstrap.preInit()");
        }
        if (injectStateTweaker) {
            List tweakClasses;
            if (MixinBootstrap.findInStackTrace(Launch.class.getName(), "launch") < 4) {
                logger.warn("MixinBootstrap.register() called during a tweak constructor. Expect CoModificationException in 5.. 4..");
            }
            if ((tweakClasses = (List)Blackboard.get("TweakClasses")) != null) {
                tweakClasses.add(MixinEnvironment.class.getName() + "$EnvironmentStateTweaker");
            }
        }
    }

    private static int findInStackTrace(String className, String methodName) {
        StackTraceElement[] stackTrace;
        Thread currentThread = Thread.currentThread();
        if (!"main".equals(currentThread.getName())) {
            return 0;
        }
        for (StackTraceElement s : stackTrace = currentThread.getStackTrace()) {
            if (!className.equals(s.getClassName()) || !methodName.equals(s.getMethodName())) continue;
            return s.getLineNumber();
        }
        return 0;
    }

    static {
        Launch.classLoader.addClassLoaderExclusion(ASM_PACKAGE);
        Launch.classLoader.addClassLoaderExclusion(MIXIN_PACKAGE);
        Launch.classLoader.addClassLoaderExclusion(MIXIN_UTIL_PACKAGE);
        Launch.classLoader.addClassLoaderExclusion(LAUNCH_PACKAGE);
    }
}

