/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.InterfaceMixinApplicator;
import org.spongepowered.asm.mixin.transformer.MixinApplicator;
import org.spongepowered.asm.mixin.transformer.MixinInfo;

class TargetClassContext {
    private final String sessionId;
    private final String className;
    private final ClassNode classNode;
    private final ClassInfo classInfo;
    private final SortedSet<MixinInfo> mixins;
    private final Map<String, Counter> injectorMethodIndices = new HashMap<String, Counter>();
    private final boolean disableHandlerRemap;
    private boolean applied;

    TargetClassContext(String sessionId, String name, ClassNode classNode, SortedSet<MixinInfo> mixins) {
        this.sessionId = sessionId;
        this.className = name;
        this.classNode = classNode;
        this.classInfo = ClassInfo.fromClassNode(classNode);
        this.mixins = mixins;
        this.disableHandlerRemap = MixinEnvironment.getCurrentEnvironment().getOption(MixinEnvironment.Option.DEBUG_DISABLE_HANDLER_REMAP);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getName() {
        return this.classNode.name;
    }

    public String getClassName() {
        return this.className;
    }

    public ClassNode getClassNode() {
        return this.classNode;
    }

    public List<MethodNode> getMethods() {
        return this.classNode.methods;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public SortedSet<MixinInfo> getMixins() {
        return this.mixins;
    }

    public String getHandlerName(AnnotationNode annotation, MethodNode method, boolean surrogate) {
        if (this.disableHandlerRemap) {
            return method.name;
        }
        String descriptor = String.format("%s%s", method.name, method.desc);
        Counter id = this.injectorMethodIndices.get(descriptor);
        if (id == null) {
            id = new Counter();
            this.injectorMethodIndices.put(descriptor, id);
        } else if (!surrogate) {
            ++id.value;
        }
        return String.format("%s$%s$%d", InjectionInfo.getInjectorPrefix(annotation), method.name, id.value);
    }

    public void applyMixins() {
        if (this.applied) {
            throw new IllegalStateException("Mixins already applied to target class " + this.className);
        }
        this.applied = true;
        MixinApplicator applicator = this.createApplicator();
        applicator.apply(this.mixins);
    }

    private MixinApplicator createApplicator() {
        if (this.classInfo.isInterface()) {
            return new InterfaceMixinApplicator(this);
        }
        return new MixinApplicator(this);
    }

    static class Counter {
        public int value;

        Counter() {
        }
    }
}

