/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.launch;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.MainAttributes;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.launch.MixinTweakContainer;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class MixinTweaker
implements ITweaker {
    private static final String MFATT_TWEAKER = "TweakClass";
    private static final String DEFAULT_MAIN_CLASS = "net.minecraft.client.main.Main";
    private static final Logger logger = LogManager.getLogger((String)"mixin");
    private final Map<URI, MixinTweakContainer> containers = new LinkedHashMap<URI, MixinTweakContainer>();
    private MixinTweakContainer primaryContainer;
    private boolean prepared = false;

    public MixinTweaker() {
        MixinBootstrap.preInit();
        URI uri = null;
        try {
            uri = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
            if (uri != null) {
                this.primaryContainer = this.addContainer(uri);
            }
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
    }

    public final MixinTweakContainer addContainer(URI uri) {
        MixinTweakContainer existingContainer = this.containers.get(uri);
        if (existingContainer != null) {
            return existingContainer;
        }
        logger.debug("Adding mixin launch agents for container {}", new Object[]{uri});
        MixinTweakContainer container = new MixinTweakContainer(uri);
        this.containers.put(uri, container);
        if (this.prepared) {
            container.prepare();
        }
        return container;
    }

    public final void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        MixinBootstrap.register();
        this.prepared = true;
        for (MixinTweakContainer container : this.containers.values()) {
            container.prepare();
        }
        this.parseArgs(args);
    }

    private void parseArgs(List<String> args) {
        boolean captureNext = false;
        for (String arg : args) {
            if (captureNext) {
                MixinTweaker.addConfig(arg);
            }
            captureNext = "--mixin".equals(arg);
        }
    }

    public final void injectIntoClassLoader(LaunchClassLoader classLoader) {
        if (this.primaryContainer != null) {
            this.primaryContainer.initPrimaryContainer();
        }
        this.scanClasspath();
        logger.debug("injectIntoClassLoader running with {} agents", new Object[]{this.containers.size()});
        for (MixinTweakContainer container : this.containers.values()) {
            try {
                container.injectIntoClassLoader(classLoader);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void scanClasspath() {
        for (URL url : Launch.classLoader.getSources()) {
            try {
                URI uri = url.toURI();
                if (this.containers.containsKey(uri)) continue;
                logger.debug("Scanning {} for mixin tweaker", new Object[]{uri});
                if (!"file".equals(uri.getScheme()) || !new File(uri).exists()) continue;
                MainAttributes attributes = MainAttributes.of(uri);
                String tweaker = attributes.get(MFATT_TWEAKER);
                if (!MixinTweaker.class.getName().equals(tweaker)) continue;
                logger.debug("{} contains a mixin tweaker, adding agents", new Object[]{uri});
                this.addContainer(uri);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getLaunchTarget() {
        for (MixinTweakContainer container : this.containers.values()) {
            String mainClass = container.getLaunchTarget();
            if (mainClass == null) continue;
            return mainClass;
        }
        return DEFAULT_MAIN_CLASS;
    }

    public String[] getLaunchArguments() {
        return new String[0];
    }

    static void setCompatibilityLevel(String level) {
        try {
            MixinEnvironment.CompatibilityLevel value = MixinEnvironment.CompatibilityLevel.valueOf(level.toUpperCase());
            logger.debug("Setting mixin compatibility level: {}", new Object[]{value});
            MixinEnvironment.setCompatibilityLevel(value);
        }
        catch (IllegalArgumentException ex) {
            logger.warn("Invalid compatibility level specified: {}", new Object[]{level});
        }
    }

    static void addConfig(String config) {
        if (config.endsWith(".json")) {
            logger.debug("Registering mixin config: {}", new Object[]{config});
            MixinEnvironment.getDefaultEnvironment().addConfiguration(config);
        } else if (config.contains(".json@")) {
            int pos = config.indexOf(".json@");
            String phaseName = config.substring(pos + 6);
            config = config.substring(0, pos + 5);
            MixinEnvironment.Phase phase = MixinEnvironment.Phase.forName(phaseName);
            if (phase != null) {
                logger.debug("Registering mixin config: {}", new Object[]{config});
                MixinEnvironment.getEnvironment(phase).addConfiguration(config);
            }
        }
    }

    static void addTokenProvider(String provider) {
        if (provider.contains("@")) {
            String[] parts = provider.split("@", 2);
            MixinEnvironment.Phase phase = MixinEnvironment.Phase.forName(parts[1]);
            if (phase != null) {
                logger.debug("Registering token provider class: {}", new Object[]{parts[0]});
                MixinEnvironment.getEnvironment(phase).registerTokenProviderClass(parts[0]);
            }
            return;
        }
        MixinEnvironment.getDefaultEnvironment().registerTokenProviderClass(provider);
    }
}

