/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinApplyError;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.MixinException;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinErrorHandler;
import org.spongepowered.asm.mixin.transformer.IMixinTransformerModule;
import org.spongepowered.asm.mixin.transformer.InvalidMixinException;
import org.spongepowered.asm.mixin.transformer.MixinConfig;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinTransformerError;
import org.spongepowered.asm.mixin.transformer.MixinTransformerModuleCheckClass;
import org.spongepowered.asm.mixin.transformer.MixinTransformerModuleInterfaceChecker;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.TreeInfo;
import org.spongepowered.asm.mixin.transformer.debug.IDecompiler;
import org.spongepowered.asm.mixin.transformer.debug.IHotSwap;
import org.spongepowered.asm.transformers.TreeTransformer;

public class MixinTransformer
extends TreeTransformer {
    static final File DEBUG_OUTPUT = new File(".mixin.out");
    private final Logger logger = LogManager.getLogger((String)"mixin");
    private final List<MixinConfig> configs = new ArrayList<MixinConfig>();
    private final List<MixinConfig> pendingConfigs = new ArrayList<MixinConfig>();
    private final List<IMixinTransformerModule> modules = new ArrayList<IMixinTransformerModule>();
    private MixinEnvironment currentEnvironment;
    private final ReEntranceState lock = new ReEntranceState(1);
    private final String sessionId = UUID.randomUUID().toString();
    private Level verboseLoggingLevel = Level.DEBUG;
    private boolean errorState = false;
    private final File classExportDir = new File(DEBUG_OUTPUT, "class");
    private final IDecompiler decompiler;
    private final IHotSwap hotSwapper;

    MixinTransformer() {
        MixinEnvironment environment = MixinEnvironment.getCurrentEnvironment();
        Object globalMixinTransformer = environment.getActiveTransformer();
        if (globalMixinTransformer instanceof IClassTransformer) {
            throw new MixinException("Terminating MixinTransformer instance " + this);
        }
        environment.setActiveTransformer(this);
        TreeInfo.setLock(this.lock);
        this.decompiler = this.initDecompiler(new File(DEBUG_OUTPUT, "java"));
        this.hotSwapper = this.initHotSwapper();
        try {
            FileUtils.deleteDirectory((File)this.classExportDir);
        }
        catch (IOException ex) {
            this.logger.warn("Error cleaning class output directory: {}", new Object[]{ex.getMessage()});
        }
    }

    private IDecompiler initDecompiler(File outputPath) {
        if (!MixinEnvironment.getCurrentEnvironment().getOption(MixinEnvironment.Option.DEBUG_EXPORT_DECOMPILE)) {
            return null;
        }
        try {
            this.logger.info("Attempting to load Fernflower decompiler");
            Class<?> clazz = Class.forName("org.spongepowered.asm.mixin.transformer.debug.RuntimeDecompiler");
            Constructor<?> ctor = clazz.getDeclaredConstructor(File.class);
            IDecompiler decompiler = (IDecompiler)ctor.newInstance(outputPath);
            this.logger.info("Fernflower decompiler was successfully initialised, exported classes will be decompiled");
            return decompiler;
        }
        catch (Throwable th) {
            this.logger.info("Fernflower could not be loaded, exported classes will not be decompiled. {}: {}", new Object[]{th.getClass().getSimpleName(), th.getMessage()});
            return null;
        }
    }

    private IHotSwap initHotSwapper() {
        if (!MixinEnvironment.getCurrentEnvironment().getOption(MixinEnvironment.Option.HOT_SWAP)) {
            return null;
        }
        try {
            this.logger.info("Attempting to load Hot-Swap agent");
            Class<?> clazz = Class.forName("org.spongepowered.tools.agent.MixinAgent");
            Constructor<?> ctor = clazz.getDeclaredConstructor(MixinTransformer.class);
            return (IHotSwap)ctor.newInstance(this);
        }
        catch (Throwable th) {
            this.logger.info("Hot-swap agent could not be loaded, hot swapping of mixins won't work. {}: {}", new Object[]{th.getClass().getSimpleName(), th.getMessage()});
            return null;
        }
    }

    public void audit() {
        HashSet<String> unhandled = new HashSet<String>();
        for (MixinConfig config : this.configs) {
            unhandled.addAll(config.getUnhandledTargets());
        }
        for (String nextClass : unhandled) {
            try {
                this.logger.info("Force-loading class {}", new Object[]{nextClass});
                Class.forName(nextClass, true, (ClassLoader)Launch.classLoader);
            }
            catch (ClassNotFoundException ex) {
                throw new Error("Could not force-load " + nextClass);
            }
        }
    }

    public synchronized byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null || transformedName == null || this.errorState) {
            return basicClass;
        }
        boolean locked = this.lock.push().isSet();
        MixinEnvironment environment = MixinEnvironment.getCurrentEnvironment();
        if (this.currentEnvironment != environment && !locked) {
            try {
                this.init(environment);
            }
            catch (Exception ex) {
                this.lock.pop();
                throw new MixinException(ex);
            }
        }
        try {
            TreeSet<MixinInfo> mixins = null;
            boolean invalidRef = false;
            for (MixinConfig config : this.configs) {
                if (config.packageMatch(transformedName)) {
                    if (config.canPassThrough(transformedName)) {
                        byte[] byArray = this.passThrough(name, transformedName, basicClass);
                        return byArray;
                    }
                    invalidRef = true;
                    continue;
                }
                if (!config.hasMixinsFor(transformedName)) continue;
                if (mixins == null) {
                    mixins = new TreeSet<MixinInfo>();
                }
                mixins.addAll(config.getMixinsFor(transformedName));
            }
            if (invalidRef) {
                throw new NoClassDefFoundError(String.format("%s is a mixin class and cannot be referenced directly", transformedName));
            }
            if (mixins != null) {
                if (locked) {
                    this.logger.warn("Re-entrance detected, this will cause serious problems.", (Throwable)new MixinException());
                    throw new MixinApplyError("Re-entrance error.");
                }
                if (this.hotSwapper != null) {
                    this.hotSwapper.registerTargetClass(transformedName, basicClass);
                }
                try {
                    ClassNode targetClassNode = this.readClass(basicClass, true);
                    TargetClassContext context = new TargetClassContext(this.sessionId, transformedName, targetClassNode, mixins);
                    basicClass = this.applyMixins(context);
                }
                catch (InvalidMixinException th) {
                    if (environment.getOption(MixinEnvironment.Option.DUMP_TARGET_ON_FAILURE)) {
                        this.dumpClass(transformedName.replace('.', '/') + ".target", basicClass);
                    }
                    this.handleMixinErrorState(transformedName, th);
                }
            }
            byte[] byArray = basicClass;
            return byArray;
        }
        catch (Exception ex) {
            if (environment.getOption(MixinEnvironment.Option.DUMP_TARGET_ON_FAILURE)) {
                this.dumpClass(transformedName.replace('.', '/') + ".target", basicClass);
            }
            throw new MixinTransformerError("An unexpected critical error was encountered", ex);
        }
        finally {
            this.lock.pop();
        }
    }

    public List<String> reload(String mixinClass, byte[] bytes) {
        if (this.lock.getDepth() > 0) {
            throw new MixinApplyError("Cannot reload mixin if re-entrant lock entered");
        }
        ArrayList<String> targets = new ArrayList<String>();
        for (MixinConfig config : this.configs) {
            targets.addAll(config.reloadMixin(mixinClass, bytes));
        }
        return targets;
    }

    private void init(MixinEnvironment environment) {
        this.verboseLoggingLevel = environment.getOption(MixinEnvironment.Option.DEBUG_VERBOSE) ? Level.INFO : Level.DEBUG;
        this.logger.log(this.verboseLoggingLevel, "Preparing mixins for {}", new Object[]{environment});
        long startTime = System.currentTimeMillis();
        this.addConfigs(environment);
        this.addModules(environment);
        this.initConfigs();
        this.currentEnvironment = environment;
        double elapsedTime = (double)(System.currentTimeMillis() - startTime) * 0.001;
        if (elapsedTime > 0.25) {
            this.logger.log(this.verboseLoggingLevel, "Mixin preparation completed in {} sec", new Object[]{new DecimalFormat("###0.000").format(elapsedTime)});
        }
    }

    private void addConfigs(MixinEnvironment environment) {
        List<String> configs = environment.getMixinConfigs();
        if (configs != null) {
            for (String configFile : configs) {
                try {
                    MixinConfig config = MixinConfig.create(configFile, environment);
                    if (config == null) continue;
                    this.logger.log(this.verboseLoggingLevel, "Adding config {}", new Object[]{config});
                    this.pendingConfigs.add(config);
                }
                catch (Exception ex) {
                    this.logger.warn(String.format("Failed to load mixin config: %s", configFile), (Throwable)ex);
                }
            }
        }
        Collections.sort(this.pendingConfigs);
    }

    private void addModules(MixinEnvironment environment) {
        this.modules.clear();
        if (environment.getOption(MixinEnvironment.Option.DEBUG_VERIFY)) {
            this.modules.add(new MixinTransformerModuleCheckClass());
        }
        if (environment.getOption(MixinEnvironment.Option.CHECK_IMPLEMENTS)) {
            this.modules.add(new MixinTransformerModuleInterfaceChecker());
        }
    }

    private void initConfigs() {
        for (MixinConfig config : this.pendingConfigs) {
            try {
                this.logger.log(this.verboseLoggingLevel, "Preparing {} ({})", new Object[]{config, config.getMixinCount()});
                config.initialise(this.hotSwapper);
            }
            catch (Exception ex) {
                this.logger.error("Error encountered whilst initialising mixin config '" + config.getName() + "': " + ex.getMessage(), (Throwable)ex);
            }
        }
        for (MixinConfig config : this.pendingConfigs) {
            IMixinConfigPlugin plugin = config.getPlugin();
            if (plugin == null) continue;
            HashSet<String> otherTargets = new HashSet<String>();
            for (MixinConfig otherConfig : this.pendingConfigs) {
                if (otherConfig.equals(config)) continue;
                otherTargets.addAll(otherConfig.getTargets());
            }
            plugin.acceptTargets(config.getTargets(), Collections.unmodifiableSet(otherTargets));
        }
        for (MixinConfig config : this.pendingConfigs) {
            try {
                config.postInitialise(this.hotSwapper);
            }
            catch (Exception ex) {
                this.logger.error("Error encountered during mixin config postInit step'" + config.getName() + "': " + ex.getMessage(), (Throwable)ex);
            }
        }
        this.configs.addAll(this.pendingConfigs);
        Collections.sort(this.configs);
        this.pendingConfigs.clear();
    }

    private byte[] passThrough(String name, String transformedName, byte[] basicClass) {
        ClassNode passThroughClass = this.readClass(basicClass, true);
        passThroughClass.access |= 1;
        for (FieldNode field : passThroughClass.fields) {
            if ((field.access & 6) != 0) continue;
            field.access |= 1;
        }
        for (MethodNode method : passThroughClass.methods) {
            if ((method.access & 6) != 0) continue;
            method.access |= 1;
        }
        return this.writeClass(transformedName, passThroughClass);
    }

    private byte[] applyMixins(TargetClassContext context) {
        block2: {
            this.preApply(context);
            this.apply(context);
            try {
                this.postApply(context);
            }
            catch (MixinTransformerModuleCheckClass.ValidationFailedException ex) {
                this.logger.info(ex.getMessage());
                if (!MixinEnvironment.getCurrentEnvironment().getOption(MixinEnvironment.Option.DEBUG_EXPORT)) break block2;
                this.writeClass(context);
            }
        }
        return this.writeClass(context);
    }

    private void preApply(TargetClassContext context) {
        for (IMixinTransformerModule module : this.modules) {
            module.preApply(context);
        }
    }

    private void apply(TargetClassContext context) {
        context.applyMixins();
    }

    private void postApply(TargetClassContext context) {
        for (IMixinTransformerModule module : this.modules) {
            module.postApply(context);
        }
    }

    private void handleMixinErrorState(String targetClassName, InvalidMixinException th) throws MixinApplyError {
        IMixinErrorHandler.ErrorAction action;
        this.errorState = true;
        MixinInfo mixin = th.getMixin();
        MixinConfig config = mixin.getParent();
        IMixinErrorHandler.ErrorAction errorAction = action = config.isRequired() ? IMixinErrorHandler.ErrorAction.ERROR : IMixinErrorHandler.ErrorAction.WARN;
        if (MixinEnvironment.getCurrentEnvironment().getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) {
            th.printStackTrace();
        }
        for (IMixinErrorHandler handler : this.getErrorHandlers(mixin.getPhase())) {
            IMixinErrorHandler.ErrorAction newAction = handler.onError(targetClassName, th, mixin, action);
            if (newAction == null) continue;
            action = newAction;
        }
        this.logger.log(action.logLevel, String.format("Mixin failed applying %s -> %s: %s %s", mixin, targetClassName, th.getClass().getName(), th.getMessage()), (Throwable)th);
        this.errorState = false;
        if (action == IMixinErrorHandler.ErrorAction.ERROR) {
            throw new MixinApplyError(String.format("Mixin [%s] from phase [%s] in config [%s] FAILED", mixin, mixin.getPhase(), config), th);
        }
    }

    private List<IMixinErrorHandler> getErrorHandlers(MixinEnvironment.Phase phase) {
        ArrayList<IMixinErrorHandler> handlers = new ArrayList<IMixinErrorHandler>();
        for (String handlerClassName : MixinEnvironment.getEnvironment(phase).getErrorHandlerClasses()) {
            try {
                this.logger.info("Instancing error handler class {}", new Object[]{handlerClassName});
                Class<?> handlerClass = Class.forName(handlerClassName, true, (ClassLoader)Launch.classLoader);
                IMixinErrorHandler handler = (IMixinErrorHandler)handlerClass.newInstance();
                if (handler == null) continue;
                handlers.add(handler);
            }
            catch (Throwable th) {}
        }
        return handlers;
    }

    private String prepareFilter(String filter) {
        filter = "^\\Q" + filter.replace("**", "\u0081").replace("*", "\u0082").replace("?", "\u0083") + "\\E$";
        return filter.replace("\u0081", "\\E.*\\Q").replace("\u0082", "\\E[^\\.]+\\Q").replace("\u0083", "\\E.\\Q").replace("\\Q\\E", "");
    }

    private boolean applyFilter(String filter, String subject) {
        return Pattern.compile(this.prepareFilter(filter), 2).matcher(subject).matches();
    }

    private byte[] writeClass(TargetClassContext context) {
        return this.writeClass(context.getClassName(), context.getClassNode());
    }

    private byte[] writeClass(String transformedName, ClassNode targetClass) {
        String filter;
        byte[] bytes = this.writeClass(targetClass);
        MixinEnvironment environment = MixinEnvironment.getCurrentEnvironment();
        if (environment.getOption(MixinEnvironment.Option.DEBUG_EXPORT) && ((filter = environment.getOptionValue(MixinEnvironment.Option.DEBUG_EXPORT_FILTER)) == null || this.applyFilter(filter, transformedName))) {
            File outputFile = this.dumpClass(transformedName.replace('.', '/'), bytes);
            if (this.decompiler != null) {
                this.decompiler.decompile(outputFile);
            }
        }
        return bytes;
    }

    private File dumpClass(String fileName, byte[] bytes) {
        File outputFile = new File(this.classExportDir, fileName + ".class");
        try {
            FileUtils.writeByteArrayToFile((File)outputFile, (byte[])bytes);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return outputFile;
    }

    class ReEntranceState {
        private final int maxDepth;
        private int depth = 0;
        private boolean semaphore = false;

        public ReEntranceState(int maxDepth) {
            this.maxDepth = maxDepth;
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }

        public int getDepth() {
            return this.depth;
        }

        ReEntranceState push() {
            ++this.depth;
            this.checkAndSet();
            return this;
        }

        ReEntranceState pop() {
            if (this.depth == 0) {
                throw new IllegalStateException("ReEntranceState pop() with zero depth");
            }
            --this.depth;
            return this;
        }

        boolean check() {
            return this.depth > this.maxDepth;
        }

        boolean checkAndSet() {
            return this.semaphore |= this.check();
        }

        ReEntranceState set() {
            this.semaphore = true;
            return this;
        }

        boolean isSet() {
            return this.semaphore;
        }

        ReEntranceState clear() {
            this.semaphore = false;
            return this;
        }
    }

    public static class Proxy
    implements IClassTransformer {
        private static List<Proxy> proxies = new ArrayList<Proxy>();
        private static MixinTransformer transformer = new MixinTransformer();
        private boolean isActive = true;

        public Proxy() {
            for (Proxy hook : proxies) {
                hook.isActive = false;
            }
            proxies.add(this);
            LogManager.getLogger((String)"mixin").debug("Adding new mixin transformer proxy #{}", new Object[]{proxies.size()});
        }

        public byte[] transform(String name, String transformedName, byte[] basicClass) {
            if (this.isActive) {
                return transformer.transform(name, transformedName, basicClass);
            }
            return basicClass;
        }
    }
}

