/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.invoke;

import com.google.common.base.Joiner;
import com.google.common.collect.ObjectArrays;
import com.google.common.primitives.Ints;
import java.util.List;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.injection.InjectionNodes;
import org.spongepowered.asm.mixin.injection.InvalidInjectionException;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.invoke.InvokeInjector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.ASMHelper;

public class RedirectInjector
extends InvokeInjector {
    private Meta meta;

    public RedirectInjector(InjectionInfo info) {
        super(info, "@Redirect");
        int priority = info.getContext().getPriority();
        boolean isFinal = ASMHelper.getVisibleAnnotation(this.methodNode, Final.class) != null;
        this.meta = new Meta(priority, isFinal, this.info.toString(), this.methodNode.desc);
    }

    @Override
    protected void addTargetNode(Target target, List<InjectionNodes.InjectionNode> myNodes, AbstractInsnNode insn) {
        Meta other;
        InjectionNodes.InjectionNode node = target.injectionNodes.get(insn);
        if (node != null && (other = (Meta)node.getDecoration("redirector")) != null && other.getOwner() != this) {
            if (other.priority >= this.meta.priority) {
                Injector.logger.warn("{} conflict. Skipping {} with priority {}, already redirected by {} with priority {}", new Object[]{this.annotationType, this.info, this.meta.priority, other.name, other.priority});
                return;
            }
            if (other.isFinal) {
                throw new InvalidInjectionException(this.info, this.annotationType + " conflict: " + this + " failed because target was already remapped by " + other.name);
            }
        }
        myNodes.add(target.injectionNodes.add(insn).decorate("redirector", this.meta));
    }

    @Override
    protected void inject(Target target, InjectionNodes.InjectionNode node) {
        Meta other = (Meta)node.getDecoration("redirector");
        if (other.getOwner() != this) {
            Injector.logger.warn("{} conflict. Skipping {} with priority {}, already redirected by {} with priority {}", new Object[]{this.annotationType, this.info, this.meta.priority, other.name, other.priority});
            return;
        }
        if (node.isReplaced()) {
            throw new UnsupportedOperationException("Redirector target failure for " + this.info);
        }
        if (node.getCurrentTarget() instanceof MethodInsnNode) {
            this.injectAtInvoke(target, node);
            return;
        }
        if (node.getCurrentTarget() instanceof FieldInsnNode) {
            this.injectAtFieldAccess(target, node);
            return;
        }
        throw new InvalidInjectionException(this.info, this.annotationType + " annotation on is targetting an invalid insn in " + target + " in " + this);
    }

    @Override
    protected void injectAtInvoke(Target target, InjectionNodes.InjectionNode node) {
        MethodInsnNode methodNode = (MethodInsnNode)node.getCurrentTarget();
        boolean injectTargetParams = false;
        boolean targetIsStatic = methodNode.getOpcode() == 184;
        Type ownerType = Type.getType("L" + methodNode.owner + ";");
        Type returnType = Type.getReturnType(methodNode.desc);
        Object[] args = Type.getArgumentTypes(methodNode.desc);
        Object[] stackVars = targetIsStatic ? args : (Type[])ObjectArrays.concat((Object)ownerType, (Object[])args);
        String desc = Injector.printArgs((Type[])stackVars) + returnType;
        if (!desc.equals(this.methodNode.desc)) {
            String alternateDesc = Injector.printArgs((Type[])ObjectArrays.concat((Object[])stackVars, (Object[])target.arguments, Type.class)) + returnType;
            if (alternateDesc.equals(this.methodNode.desc)) {
                injectTargetParams = true;
            } else {
                throw new InvalidInjectionException(this.info, this.annotationType + " handler method " + this + " has an invalid signature, expected " + desc + " found " + this.methodNode.desc);
            }
        }
        InsnList insns = new InsnList();
        int extraLocals = ASMHelper.getArgsSize((Type[])stackVars) + 1;
        int extraStack = 1;
        int[] argMap = this.storeArgs(target, (Type[])stackVars, insns, 0);
        if (injectTargetParams) {
            int argSize = ASMHelper.getArgsSize(target.arguments);
            extraLocals += argSize;
            extraStack += argSize;
            argMap = Ints.concat((int[][])new int[][]{argMap, target.argIndices});
        }
        AbstractInsnNode insn = this.invokeHandlerWithArgs(this.methodArgs, insns, argMap);
        target.replaceNode(methodNode, insn, insns);
        target.addToLocals(extraLocals);
        target.addToStack(extraStack);
    }

    private void injectAtFieldAccess(Target target, InjectionNodes.InjectionNode node) {
        FieldInsnNode fieldNode = (FieldInsnNode)node.getCurrentTarget();
        boolean staticField = fieldNode.getOpcode() == 178 || fieldNode.getOpcode() == 179;
        Type ownerType = Type.getType("L" + fieldNode.owner + ";");
        Type fieldType = Type.getType(fieldNode.desc);
        AbstractInsnNode invoke = null;
        InsnList insns = new InsnList();
        if (fieldNode.getOpcode() == 178 || fieldNode.getOpcode() == 180) {
            invoke = this.injectAtGetField(insns, target, fieldNode, staticField, ownerType, fieldType);
        } else if (fieldNode.getOpcode() == 179 || fieldNode.getOpcode() == 181) {
            invoke = this.injectAtPutField(insns, target, fieldNode, staticField, ownerType, fieldType);
        } else {
            throw new InvalidInjectionException(this.info, "Unspported opcode " + fieldNode.getOpcode() + " on FieldInsnNode for " + this.info);
        }
        target.replaceNode(fieldNode, invoke, insns);
    }

    private AbstractInsnNode injectAtGetField(InsnList insns, Target target, FieldInsnNode node, boolean staticField, Type owner, Type fieldType) {
        String handlerDesc = staticField ? ASMHelper.generateDescriptor(fieldType, new Object[0]) : ASMHelper.generateDescriptor(fieldType, owner);
        boolean withArgs = this.checkDescriptor(handlerDesc, target, "getter");
        if (!this.isStatic) {
            insns.add(new VarInsnNode(25, 0));
            if (!staticField) {
                insns.add(new InsnNode(95));
            }
        }
        if (withArgs) {
            this.pushArgs(target.arguments, insns, target.argIndices, 0, target.arguments.length);
            target.addToStack(ASMHelper.getArgsSize(target.arguments));
        }
        target.addToStack(this.isStatic ? 0 : 1);
        return this.invokeHandler(insns);
    }

    private AbstractInsnNode injectAtPutField(InsnList insns, Target target, FieldInsnNode node, boolean staticField, Type owner, Type fieldType) {
        String handlerDesc = staticField ? ASMHelper.generateDescriptor(null, fieldType) : ASMHelper.generateDescriptor(null, owner, fieldType);
        boolean withArgs = this.checkDescriptor(handlerDesc, target, "setter");
        if (!this.isStatic) {
            if (staticField) {
                insns.add(new VarInsnNode(25, 0));
                insns.add(new InsnNode(95));
            } else {
                int marshallVar = target.allocateLocals(fieldType.getSize());
                insns.add(new VarInsnNode(fieldType.getOpcode(54), marshallVar));
                insns.add(new VarInsnNode(25, 0));
                insns.add(new InsnNode(95));
                insns.add(new VarInsnNode(fieldType.getOpcode(21), marshallVar));
            }
        }
        if (withArgs) {
            this.pushArgs(target.arguments, insns, target.argIndices, 0, target.arguments.length);
            target.addToStack(ASMHelper.getArgsSize(target.arguments));
        }
        target.addToStack(!this.isStatic && !staticField ? 1 : 0);
        return this.invokeHandler(insns);
    }

    private boolean checkDescriptor(String desc, Target target, String type) {
        if (this.methodNode.desc.equals(desc)) {
            return false;
        }
        int pos = desc.indexOf(41);
        String alternateDesc = String.format("%s%s%s", desc.substring(0, pos), Joiner.on((String)"").join((Object[])target.arguments), desc.substring(pos));
        if (this.methodNode.desc.equals(alternateDesc)) {
            return true;
        }
        throw new InvalidInjectionException(this.info, this.annotationType + " field " + type + " " + this + " has an invalid signature. Expected " + desc + " but found " + this.methodNode.desc);
    }

    class Meta {
        public static final String KEY = "redirector";
        final int priority;
        final boolean isFinal;
        final String name;
        final String desc;

        public Meta(int priority, boolean isFinal, String name, String desc) {
            this.priority = priority;
            this.isFinal = isFinal;
            this.name = name;
            this.desc = desc;
        }

        RedirectInjector getOwner() {
            return RedirectInjector.this;
        }
    }
}

