/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassWriter;
import org.spongepowered.asm.mixin.transformer.ClassInfo;

public class MixinClassWriter
extends ClassWriter {
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";

    public MixinClassWriter(int flags) {
        super(flags);
    }

    public MixinClassWriter(ClassReader classReader, int flags) {
        super(classReader, flags);
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        ClassInfo d;
        ClassInfo c = ClassInfo.forName(type1);
        if (c.hasSuperClass(d = ClassInfo.forName(type2))) {
            return type2;
        }
        if (d.hasSuperClass(c)) {
            return type1;
        }
        if (c.isInterface() || d.isInterface()) {
            return JAVA_LANG_OBJECT;
        }
        do {
            if ((c = c.getSuperClass()) != null) continue;
            return JAVA_LANG_OBJECT;
        } while (!d.hasSuperClass(c));
        return c.getName();
    }
}

