/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.InvalidInterfaceMixinException;
import org.spongepowered.asm.mixin.transformer.MixinApplicator;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinPreProcessor;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;

class InterfaceMixinPreProcessor
extends MixinPreProcessor {
    InterfaceMixinPreProcessor(MixinInfo mixin, ClassNode classNode) {
        super(mixin, classNode);
    }

    @Override
    protected void prepareMethod(MethodNode mixinMethod, ClassInfo.Method method) {
        if (!MixinApplicator.hasFlag(mixinMethod, 1)) {
            throw new InvalidInterfaceMixinException(this.mixin, "Interface mixin contains a non-public method! Found " + method + " in " + this.mixin);
        }
        super.prepareMethod(mixinMethod, method);
    }

    @Override
    protected boolean validateField(MixinTargetContext context, FieldNode field, AnnotationNode shadow) {
        if (!MixinApplicator.hasFlag(field, 8)) {
            throw new InvalidInterfaceMixinException(this.mixin, "Interface mixin contains an instance field! Found " + field.name + " in " + this.mixin);
        }
        return super.validateField(context, field, shadow);
    }
}

