/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.lang.annotation.Annotation;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.RemapperChain;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.InterfaceInfo;
import org.spongepowered.asm.mixin.transformer.InvalidMixinException;
import org.spongepowered.asm.mixin.transformer.MixinApplicator;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.meta.MixinRenamed;
import org.spongepowered.asm.util.ASMHelper;

class MixinPreProcessor {
    private static final Logger logger = LogManager.getLogger((String)"mixin");
    protected final MixinInfo mixin;
    protected final ClassNode classNode;
    private final boolean verboseLogging;
    private boolean prepared;
    private boolean attached;

    MixinPreProcessor(MixinInfo mixin, ClassNode classNode) {
        this.mixin = mixin;
        this.classNode = classNode;
        this.verboseLogging = mixin.getParent().getEnvironment().getOption(MixinEnvironment.Option.DEBUG_VERBOSE);
    }

    MixinPreProcessor prepare() {
        if (!this.prepared) {
            this.prepared = true;
            for (MethodNode mixinMethod : this.classNode.methods) {
                ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethod);
                this.prepareMethod(mixinMethod, method);
            }
            for (FieldNode mixinField : this.classNode.fields) {
                this.prepareField(mixinField);
            }
        }
        return this;
    }

    protected void prepareMethod(MethodNode mixinMethod, ClassInfo.Method method) {
        this.prepareShadow(mixinMethod, method);
        this.prepareSoftImplements(mixinMethod, method);
    }

    protected void prepareShadow(MethodNode mixinMethod, ClassInfo.Method method) {
        AnnotationNode shadowAnnotation = ASMHelper.getVisibleAnnotation(mixinMethod, Shadow.class);
        if (shadowAnnotation == null) {
            return;
        }
        String prefix = (String)ASMHelper.getAnnotationValue(shadowAnnotation, "prefix", Shadow.class);
        if (mixinMethod.name.startsWith(prefix)) {
            ASMHelper.setVisibleAnnotation(mixinMethod, MixinRenamed.class, "originalName", mixinMethod.name);
            String newName = mixinMethod.name.substring(prefix.length());
            method.renameTo(newName);
            mixinMethod.name = newName;
        }
    }

    protected void prepareSoftImplements(MethodNode mixinMethod, ClassInfo.Method method) {
        for (InterfaceInfo iface : this.mixin.getSoftImplements()) {
            if (!iface.renameMethod(mixinMethod)) continue;
            method.renameTo(mixinMethod.name);
        }
    }

    protected void prepareField(FieldNode mixinField) {
    }

    MixinTargetContext createContextFor(TargetClassContext target) {
        MixinTargetContext context = new MixinTargetContext(this.mixin, this.classNode, target);
        this.attach(context);
        return context;
    }

    void attach(MixinTargetContext context) {
        if (this.attached) {
            throw new IllegalStateException("Preprocessor was already attached");
        }
        this.attached = true;
        this.attachMethods(context);
        this.attachFields(context);
        this.transform(context);
    }

    protected void attachMethods(MixinTargetContext context) {
        Iterator<MethodNode> iter = this.classNode.methods.iterator();
        while (iter.hasNext()) {
            MethodNode mixinMethod = iter.next();
            if (!this.validateMethod(context, mixinMethod)) {
                iter.remove();
                continue;
            }
            if (this.processInjectorMethod(context, mixinMethod)) continue;
            if (this.processMemberMethod(context, mixinMethod, Shadow.class, true, true)) {
                iter.remove();
                context.addShadowMethod(mixinMethod);
                continue;
            }
            if (this.processMemberMethod(context, mixinMethod, Overwrite.class, false, false)) continue;
            this.processMethod(mixinMethod);
        }
    }

    protected boolean validateMethod(MixinTargetContext context, MethodNode mixinMethod) {
        return true;
    }

    protected boolean processInjectorMethod(MixinTargetContext context, MethodNode mixinMethod) {
        boolean surrogate;
        AnnotationNode annotation = InjectionInfo.getInjectorAnnotation(context, mixinMethod);
        boolean bl = surrogate = ASMHelper.getVisibleAnnotation(mixinMethod, Surrogate.class) != null;
        if (annotation == null && !surrogate) {
            return false;
        }
        String handlerName = context.getHandlerName(annotation, mixinMethod, surrogate);
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethod, 10);
        method.renameTo(handlerName);
        mixinMethod.name = handlerName;
        return true;
    }

    protected boolean processMemberMethod(MixinTargetContext context, MethodNode mixinMethod, Class<? extends Annotation> annotationType, boolean mustExist, boolean mustBePrivate) {
        AnnotationNode annotation = ASMHelper.getVisibleAnnotation(mixinMethod, annotationType);
        if (annotation == null) {
            return false;
        }
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethod, 10);
        MethodNode target = MixinPreProcessor.findMethod(context.getTargetClass(), mixinMethod, annotation);
        if (target == null) {
            if (!mustExist) {
                return false;
            }
            target = MixinPreProcessor.findRemappedMethod(context.getTargetClass(), mixinMethod);
            if (target == null) {
                throw new InvalidMixinException(this.mixin, annotationType.getSimpleName() + " method " + mixinMethod.name + " was not located in the target class");
            }
            mixinMethod.name = target.name;
            method.renameTo(target.name);
        }
        if ("<init>".equals(target.name)) {
            throw new InvalidMixinException(this.mixin, "Nice try! Cannot alias a constructor!");
        }
        if (!target.name.equals(mixinMethod.name)) {
            if (mustBePrivate && (target.access & 2) == 0) {
                throw new InvalidMixinException(this.mixin, "Non-private method cannot be aliased. Found " + target.name);
            }
            mixinMethod.name = target.name;
            method.renameTo(target.name);
        }
        return true;
    }

    protected void processMethod(MethodNode mixinMethod) {
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethod);
        if (method == null) {
            return;
        }
        ClassInfo.Method parentMethod = this.mixin.getClassInfo().findMethodInHierarchy(mixinMethod, false);
        if (parentMethod != null && parentMethod.isRenamed()) {
            mixinMethod.name = parentMethod.getName();
            method.renameTo(parentMethod.getName());
        }
    }

    protected void attachFields(MixinTargetContext context) {
        Iterator<FieldNode> iter = this.classNode.fields.iterator();
        while (iter.hasNext()) {
            boolean isMutable;
            FieldNode mixinField = iter.next();
            AnnotationNode shadow = ASMHelper.getVisibleAnnotation(mixinField, Shadow.class);
            boolean isFinal = ASMHelper.getVisibleAnnotation(mixinField, Final.class) != null;
            boolean bl = isMutable = ASMHelper.getVisibleAnnotation(mixinField, Mutable.class) != null;
            if (!this.validateField(context, mixinField, shadow)) {
                iter.remove();
                continue;
            }
            context.transformDescriptor(mixinField);
            ClassInfo.Field field = this.mixin.getClassInfo().findField(mixinField);
            FieldNode target = MixinPreProcessor.findField(context.getTargetClass(), mixinField, shadow);
            if (target == null) {
                if (shadow == null) continue;
                target = MixinPreProcessor.findRemappedField(context.getTargetClass(), mixinField);
                if (target == null) {
                    throw new InvalidMixinException(this.mixin, "Shadow field " + mixinField.name + " was not located in the target class");
                }
                mixinField.name = target.name;
                field.renameTo(target.name);
            }
            if (!target.desc.equals(mixinField.desc)) {
                throw new InvalidMixinException(this.mixin, "The field " + mixinField.name + " in the target class has a conflicting signature");
            }
            if (!target.name.equals(mixinField.name)) {
                if ((target.access & 2) == 0 && (target.access & 0x1000) == 0) {
                    throw new InvalidMixinException(this.mixin, "Non-private field cannot be aliased. Found " + target.name);
                }
                mixinField.name = target.name;
                field.renameTo(target.name);
            }
            iter.remove();
            if (shadow == null) continue;
            if (field == null) {
                throw new InvalidMixinException(this.mixin, "Unable to locate field surrogate: " + mixinField.name + " in " + this.mixin);
            }
            field.setDecoratedFinal(isFinal, isMutable);
            if (this.verboseLogging && MixinApplicator.hasFlag(target, 16) != isFinal) {
                String message = isFinal ? "@Shadow field {}::{} is decorated with @Final but target is not final" : "@Shadow target {}::{} is final but shadow is not decorated with @Final";
                logger.warn(message, new Object[]{this.mixin, mixinField.name});
            }
            context.addShadowField(mixinField, field);
        }
    }

    protected boolean validateField(MixinTargetContext context, FieldNode field, AnnotationNode shadow) {
        if (MixinApplicator.hasFlag(field, 8) && !MixinApplicator.hasFlag(field, 2) && !MixinApplicator.hasFlag(field, 4096)) {
            throw new InvalidMixinException(context, String.format("Mixin %s contains non-private static field %s:%s", context, field.name, field.desc));
        }
        String prefix = (String)ASMHelper.getAnnotationValue(shadow, "prefix", Shadow.class);
        if (field.name.startsWith(prefix)) {
            throw new InvalidMixinException(context, String.format("@Shadow field %s.%s has a shadow prefix. This is not allowed.", context, field.name));
        }
        if ("super$".equals(field.name)) {
            if (field.access != 2) {
                throw new InvalidMixinException(this.mixin, "Imaginary super field " + context + "." + field.name + " must be private and non-final");
            }
            if (!field.desc.equals("L" + this.mixin.getClassRef() + ";")) {
                throw new InvalidMixinException(this.mixin, "Imaginary super field " + context + "." + field.name + " must have the same type as the parent mixin");
            }
            return false;
        }
        return true;
    }

    protected void transform(MixinTargetContext context) {
        for (MethodNode mixinMethod : this.classNode.methods) {
            ListIterator<AbstractInsnNode> iter = mixinMethod.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode insn = (AbstractInsnNode)iter.next();
                if (insn instanceof MethodInsnNode) {
                    MethodInsnNode methodNode = (MethodInsnNode)insn;
                    ClassInfo.Method method = ClassInfo.forName(methodNode.owner).findMethodInHierarchy(methodNode, true, 2);
                    if (method == null || !method.isRenamed()) continue;
                    methodNode.name = method.getName();
                    continue;
                }
                if (!(insn instanceof FieldInsnNode)) continue;
                FieldInsnNode fieldNode = (FieldInsnNode)insn;
                ClassInfo.Field field = ClassInfo.forName(fieldNode.owner).findField(fieldNode, 2);
                if (field == null || !field.isRenamed()) continue;
                fieldNode.name = field.getName();
            }
        }
    }

    protected static MethodNode findMethod(ClassNode classNode, MethodNode method, AnnotationNode annotation) {
        List aka;
        LinkedList<String> aliases = new LinkedList<String>();
        aliases.add(method.name);
        if (annotation != null && (aka = (List)ASMHelper.getAnnotationValue(annotation, "aliases")) != null) {
            aliases.addAll(aka);
        }
        return MixinPreProcessor.findMethodRecursive(classNode, aliases, method.desc);
    }

    protected static MethodNode findRemappedMethod(ClassNode classNode, MethodNode method) {
        RemapperChain remapperChain = MixinEnvironment.getCurrentEnvironment().getRemappers();
        String remappedName = remapperChain.mapMethodName(classNode.name, method.name, method.desc);
        if (remappedName.equals(method.name)) {
            return null;
        }
        LinkedList<String> aliases = new LinkedList<String>();
        aliases.add(remappedName);
        return MixinPreProcessor.findMethodRecursive(classNode, aliases, method.desc);
    }

    private static MethodNode findMethodRecursive(ClassNode classNode, Deque<String> aliases, String desc) {
        String alias = aliases.poll();
        if (alias == null) {
            return null;
        }
        for (MethodNode target : classNode.methods) {
            if (!target.name.equals(alias) || !target.desc.equals(desc)) continue;
            return target;
        }
        return MixinPreProcessor.findMethodRecursive(classNode, aliases, desc);
    }

    protected static FieldNode findField(ClassNode classNode, FieldNode field, AnnotationNode shadow) {
        List aka;
        LinkedList<String> aliases = new LinkedList<String>();
        aliases.add(field.name);
        if (shadow != null && (aka = (List)ASMHelper.getAnnotationValue(shadow, "aliases")) != null) {
            aliases.addAll(aka);
        }
        return MixinPreProcessor.findFieldRecursive(classNode, aliases, field.desc);
    }

    protected static FieldNode findRemappedField(ClassNode classNode, FieldNode field) {
        RemapperChain remapperChain = MixinEnvironment.getCurrentEnvironment().getRemappers();
        String remappedName = remapperChain.mapFieldName(classNode.name, field.name, field.desc);
        if (remappedName.equals(field.name)) {
            return null;
        }
        LinkedList<String> aliases = new LinkedList<String>();
        aliases.add(remappedName);
        return MixinPreProcessor.findFieldRecursive(classNode, aliases, field.desc);
    }

    private static FieldNode findFieldRecursive(ClassNode classNode, Deque<String> aliases, String desc) {
        String alias = aliases.poll();
        if (alias == null) {
            return null;
        }
        for (FieldNode target : classNode.fields) {
            if (!target.name.equals(alias) || !target.desc.equals(desc)) continue;
            return target;
        }
        return MixinPreProcessor.findFieldRecursive(classNode, aliases, desc);
    }
}

