/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.mixin.refmap.ReferenceMapper;
import org.spongepowered.asm.obfuscation.SrgContainer;
import org.spongepowered.asm.obfuscation.SrgField;
import org.spongepowered.asm.obfuscation.SrgMethod;
import org.spongepowered.asm.util.ObfuscationUtil;
import org.spongepowered.tools.obfuscation.AnnotatedMixin;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.TypeHandle;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;

class TargetObfuscationEnvironment {
    protected SrgContainer srgs;
    private final RemapperProxy remapper = new RemapperProxy();
    private final ObfuscationType type;
    private final IMixinAnnotationProcessor ap;
    private final String outSrgFileName;
    private final List<String> reobfSrgFileNames;
    private final ReferenceMapper refMapper;
    private boolean initDone;

    public TargetObfuscationEnvironment(IMixinAnnotationProcessor ap, ObfuscationType type, ReferenceMapper refMapper) {
        this.ap = ap;
        this.type = type;
        this.refMapper = refMapper;
        this.reobfSrgFileNames = type.getSrgFileNames(ap);
        this.outSrgFileName = type.getOutputSrgFileName(ap);
    }

    private boolean initSrgs() {
        if (!this.initDone) {
            this.initDone = true;
            if (this.reobfSrgFileNames == null) {
                this.ap.printMessage(Diagnostic.Kind.ERROR, "The " + this.type.getSrgFileOption() + " argument was not supplied, obfuscation processing will not occur");
                return false;
            }
            int successCount = 0;
            this.srgs = new SrgContainer();
            for (String srgFileName : this.reobfSrgFileNames) {
                File reobfSrgFile = new File(srgFileName);
                try {
                    if (!reobfSrgFile.isFile()) continue;
                    this.ap.printMessage(Diagnostic.Kind.NOTE, "Loading " + (Object)((Object)this.type) + " mappings from " + reobfSrgFile.getAbsolutePath());
                    this.srgs.readSrg(reobfSrgFile);
                    ++successCount;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (successCount < 1) {
                this.ap.printMessage(Diagnostic.Kind.ERROR, "No valid SRG files for " + (Object)((Object)this.type) + " could be read, processing may not be sucessful.");
                this.srgs = null;
            }
        }
        return this.srgs != null;
    }

    public ObfuscationType getType() {
        return this.type;
    }

    public void addMapping(String className, String reference, String newReference) {
        this.refMapper.addMapping(this.type.getKey(), className, reference, newReference);
        if (this.type.isDefault(this.ap)) {
            this.refMapper.addMapping(null, className, reference, newReference);
        }
    }

    public SrgMethod getObfMethod(MemberInfo method) {
        SrgMethod obfd = this.getObfMethod(method.asSrgMethod());
        if (obfd != null || !method.isFullyQualified()) {
            return obfd;
        }
        TypeHandle type = this.ap.getTypeProvider().getTypeHandle(method.owner);
        if (type == null || type.isImaginary()) {
            return null;
        }
        TypeMirror superClass = type.getElement().getSuperclass();
        if (superClass.getKind() != TypeKind.DECLARED) {
            return null;
        }
        String superClassName = ((TypeElement)((DeclaredType)superClass).asElement()).getQualifiedName().toString();
        return this.getObfMethod(new MemberInfo(method.name, superClassName.replace('.', '/'), method.desc, method.matchAll));
    }

    public SrgMethod getObfMethod(SrgMethod method) {
        return this.getObfMethod(method, true);
    }

    public SrgMethod getObfMethod(SrgMethod method, boolean srgOnly) {
        if (this.initSrgs()) {
            String remappedOwner;
            boolean remapped = true;
            SrgMethod originalMethod = method.copy();
            SrgMethod methodMapping = this.srgs.getMethodMapping(method);
            if (methodMapping == null) {
                if (srgOnly) {
                    return null;
                }
                methodMapping = originalMethod;
                remapped = false;
            }
            if ((remappedOwner = this.getObfClass(methodMapping.getOwner())) == null || remappedOwner.equals(method.getOwner()) || remappedOwner.equals(methodMapping.getOwner())) {
                return remapped ? methodMapping : null;
            }
            if (remapped) {
                return methodMapping.move(remappedOwner);
            }
            return new SrgMethod(remappedOwner, methodMapping.getSimpleName(), ObfuscationUtil.mapDescriptor(methodMapping.getDesc(), this.remapper));
        }
        return null;
    }

    public MemberInfo remapDescriptor(MemberInfo method) {
        String newDesc;
        String desc;
        String newOwner;
        boolean transformed = false;
        String owner = method.owner;
        if (owner != null && (newOwner = this.remapper.map(owner)) != null) {
            owner = newOwner;
            transformed = true;
        }
        if ((desc = method.desc) != null && !(newDesc = ObfuscationUtil.mapDescriptor(method.desc, this.remapper)).equals(method.desc)) {
            desc = newDesc;
            transformed = true;
        }
        return transformed ? new MemberInfo(method.name, owner, desc, method.matchAll) : null;
    }

    public String remapDescriptor(String desc) {
        return ObfuscationUtil.mapDescriptor(desc, this.remapper);
    }

    public SrgField getObfField(String field) {
        return this.getObfField(field, true);
    }

    public SrgField getObfField(String field, boolean srgOnly) {
        if (this.initSrgs()) {
            String remappedOwner;
            SrgField originalField = new SrgField(field);
            SrgField fieldMapping = this.srgs.getFieldMapping(originalField);
            if (fieldMapping == null) {
                if (srgOnly) {
                    return null;
                }
                fieldMapping = originalField;
            }
            if ((remappedOwner = this.getObfClass(fieldMapping.getOwner())) == null || remappedOwner.equals(originalField.getOwner()) || remappedOwner.equals(fieldMapping.getOwner())) {
                return fieldMapping != originalField ? fieldMapping : null;
            }
            return fieldMapping.move(remappedOwner);
        }
        return null;
    }

    public String getObfClass(String className) {
        if (this.initSrgs()) {
            return this.srgs.getClassMapping(className);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSrgs(Filer filer, Map<String, AnnotatedMixin> mixins) {
        if (this.outSrgFileName == null) {
            return;
        }
        LinkedHashSet<String> fieldMappings = new LinkedHashSet<String>();
        LinkedHashSet<String> methodMappings = new LinkedHashSet<String>();
        for (AnnotatedMixin mixin : mixins.values()) {
            fieldMappings.addAll(mixin.getFieldMappings(this.type));
            methodMappings.addAll(mixin.getMethodMappings(this.type));
        }
        PrintWriter writer = null;
        try {
            writer = this.openFileWriter(filer, this.outSrgFileName, (Object)((Object)this.type) + " output SRGs");
            for (String fieldMapping : fieldMappings) {
                writer.println(fieldMapping);
            }
            for (String methodMapping : methodMappings) {
                writer.println(methodMapping);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private PrintWriter openFileWriter(Filer filer, String fileName, String description) throws IOException {
        if (fileName.matches("^.*[\\\\/:].*$")) {
            File outSrgFile = new File(fileName);
            outSrgFile.getParentFile().mkdirs();
            this.ap.printMessage(Diagnostic.Kind.NOTE, "Writing " + description + " to " + outSrgFile.getAbsolutePath());
            return new PrintWriter(outSrgFile);
        }
        FileObject outSrg = filer.createResource(StandardLocation.CLASS_OUTPUT, "", fileName, new Element[0]);
        this.ap.printMessage(Diagnostic.Kind.NOTE, "Writing " + description + " to " + new File(outSrg.toUri()).getAbsolutePath());
        return new PrintWriter(outSrg.openWriter());
    }

    final class RemapperProxy
    implements ObfuscationUtil.IClassRemapper {
        RemapperProxy() {
        }

        @Override
        public String map(String typeName) {
            if (TargetObfuscationEnvironment.this.srgs == null) {
                return null;
            }
            return TargetObfuscationEnvironment.this.srgs.getClassMapping(typeName);
        }

        @Override
        public String unmap(String typeName) {
            if (TargetObfuscationEnvironment.this.srgs == null) {
                return null;
            }
            return TargetObfuscationEnvironment.this.srgs.getClassMapping(typeName);
        }
    }
}

