/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.spongepowered.tools.obfuscation.interfaces.IOptionProvider;

enum ObfuscationType {
    SRG("searge", "reobfSrgFile", "reobfSrgFiles", "outSrgFile"),
    NOTCH("notch", "reobfNotchSrgFile", "reobfNotchSrgFiles", "outNotchSrgFile");

    private final String key;
    private final String srgFileArgName;
    private final String extraSrgFilesArgName;
    private final String outSrgFileArgName;

    private ObfuscationType(String displayName, String srgFileArgName, String extraSrgFilesArgName, String outSrgFileArgName) {
        this.key = displayName;
        this.srgFileArgName = srgFileArgName;
        this.extraSrgFilesArgName = extraSrgFilesArgName;
        this.outSrgFileArgName = outSrgFileArgName;
    }

    public String toString() {
        return this.key;
    }

    public String getKey() {
        return this.key;
    }

    public String getSrgFileOption() {
        return this.srgFileArgName;
    }

    public String getExtraSrgFilesOption() {
        return this.extraSrgFilesArgName;
    }

    public String getOutputSrgFileOption() {
        return this.outSrgFileArgName;
    }

    public boolean isDefault(IOptionProvider options) {
        String defaultEnv = options.getOption("defaultObfuscationEnv");
        return defaultEnv == null && this == SRG || defaultEnv != null && this.key.equals(defaultEnv.toLowerCase());
    }

    public boolean isSupported(IOptionProvider options) {
        return this.getSrgFileNames(options).size() > 0;
    }

    public List<String> getSrgFileNames(IOptionProvider options) {
        String extraSrgFiles;
        ImmutableList.Builder builder = ImmutableList.builder();
        String srgFile = options.getOption(this.srgFileArgName);
        if (srgFile != null) {
            builder.add((Object)srgFile);
        }
        if ((extraSrgFiles = options.getOption(this.extraSrgFilesArgName)) != null) {
            for (String extraSrgFile : extraSrgFiles.split(";")) {
                builder.add((Object)extraSrgFile.trim());
            }
        }
        return builder.build();
    }

    public String getOutputSrgFileName(IOptionProvider options) {
        return options.getOption(this.outSrgFileArgName);
    }
}

