/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.tools.Diagnostic;
import org.spongepowered.asm.mixin.injection.struct.InvalidMemberDescriptorException;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.tools.MirrorUtils;
import org.spongepowered.tools.obfuscation.AnnotatedMixin;
import org.spongepowered.tools.obfuscation.AnnotatedMixinElementHandler;
import org.spongepowered.tools.obfuscation.AnnotatedMixins;
import org.spongepowered.tools.obfuscation.ObfuscationData;
import org.spongepowered.tools.obfuscation.ReferenceManager;
import org.spongepowered.tools.obfuscation.TypeHandle;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.struct.Message;

class AnnotatedMixinElementHandlerInjector
extends AnnotatedMixinElementHandler {
    AnnotatedMixinElementHandlerInjector(IMixinAnnotationProcessor ap, AnnotatedMixin mixin) {
        super(ap, mixin);
    }

    public Message registerInjector(AnnotatedElementInjector elem) {
        if (this.mixin.isInterface()) {
            this.ap.printMessage(Diagnostic.Kind.ERROR, "Injector in interface is unsupported", (Element)elem.getElement());
        }
        String reference = (String)MirrorUtils.getAnnotationValue(elem.getAnnotation(), "method");
        MemberInfo targetMember = MemberInfo.parse(reference);
        if (targetMember.name == null) {
            return null;
        }
        try {
            targetMember.validate();
        }
        catch (InvalidMemberDescriptorException ex) {
            this.ap.printMessage(Diagnostic.Kind.ERROR, ex.getMessage(), (Element)elem.getElement(), elem.getAnnotation());
        }
        if (targetMember.desc != null) {
            this.validateReferencedTarget((ExecutableElement)elem.getElement(), elem.getAnnotation(), targetMember, elem.toString());
        }
        if (!elem.shouldRemap()) {
            return null;
        }
        for (TypeHandle target : this.mixin.getTargets()) {
            Message message = this.registerInjector(elem, reference, targetMember, target);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    private Message registerInjector(AnnotatedElementInjector elem, String reference, MemberInfo targetMember, TypeHandle target) {
        String desc = target.findDescriptor(targetMember);
        if (desc == null) {
            Diagnostic.Kind error;
            Diagnostic.Kind kind = error = this.mixin.isMultiTarget() ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
            if (target.isImaginary()) {
                this.ap.printMessage(error, elem + " target requires method signature because enclosing type information for " + target + " is unavailable", (Element)elem.getElement(), elem.getAnnotation());
            } else if (!"<init>".equals(targetMember.name)) {
                this.ap.printMessage(error, "Unable to determine signature for " + elem + " target method", (Element)elem.getElement(), elem.getAnnotation());
            }
            return null;
        }
        String targetName = elem + " target " + targetMember.name;
        MappingMethod targetMethod = new MappingMethod(target.getName(), targetMember.name, desc);
        ObfuscationData<MappingMethod> obfData = this.obf.getDataProvider().getObfMethod(targetMethod);
        if (obfData.isEmpty()) {
            Diagnostic.Kind error = "<init>".equals(targetMember.name) ? Diagnostic.Kind.WARNING : Diagnostic.Kind.ERROR;
            return new Message(error, "No obfuscation mapping for " + targetName, (Element)elem.getElement(), elem.getAnnotation());
        }
        try {
            if (targetMember.owner == null && this.mixin.isMultiTarget()) {
                obfData = AnnotatedMixinElementHandler.stripOwnerData(obfData);
            }
            this.obf.getReferenceManager().addMethodMapping(this.classRef, reference, obfData);
        }
        catch (ReferenceManager.ReferenceConflictException ex) {
            String conflictType = this.mixin.isMultiTarget() ? "Multi-target" : "Target";
            this.ap.printMessage(Diagnostic.Kind.ERROR, conflictType + " reference conflict for " + targetName + ": " + reference + " -> " + ex.getNew() + " previously defined as " + ex.getOld(), (Element)elem.getElement(), elem.getAnnotation());
        }
        return null;
    }

    public int registerInjectionPoint(AnnotatedElementInjectionPoint elem) {
        if (this.mixin.isInterface()) {
            this.ap.printMessage(Diagnostic.Kind.ERROR, "Injector in interface is unsupported", (Element)elem.getElement());
        }
        if (!AnnotatedMixins.getRemapValue(elem.getAt())) {
            return 0;
        }
        String type = (String)MirrorUtils.getAnnotationValue(elem.getAt(), "value");
        String target = (String)MirrorUtils.getAnnotationValue(elem.getAt(), "target");
        int remapped = this.remapReference(type + ".<target>", target, (Element)elem.getElement(), elem.getAnnotation(), elem.getAt()) ? 1 : 0;
        return remapped;
    }

    static Map<String, String> getAtArgs(AnnotationMirror at) {
        HashMap<String, String> args = new HashMap<String, String>();
        List argv = (List)MirrorUtils.getAnnotationValue(at, "args");
        if (argv != null) {
            for (AnnotationValue av : argv) {
                String arg = (String)av.getValue();
                if (arg == null) continue;
                int eqPos = arg.indexOf(61);
                if (eqPos > -1) {
                    args.put(arg.substring(0, eqPos), arg.substring(eqPos + 1));
                    continue;
                }
                args.put(arg, "");
            }
        }
        return args;
    }

    static class AnnotatedElementInjectionPoint
    extends AnnotatedMixinElementHandler.AnnotatedElement<ExecutableElement> {
        private final AnnotationMirror at;

        public AnnotatedElementInjectionPoint(ExecutableElement element, AnnotationMirror inject, AnnotationMirror at) {
            super(element, inject);
            this.at = at;
        }

        public AnnotationMirror getAt() {
            return this.at;
        }
    }

    static class AnnotatedElementInjector
    extends AnnotatedMixinElementHandler.AnnotatedElement<ExecutableElement> {
        private final boolean shouldRemap;

        public AnnotatedElementInjector(ExecutableElement element, AnnotationMirror annotation, boolean shouldRemap) {
            super(element, annotation);
            this.shouldRemap = shouldRemap;
        }

        public boolean shouldRemap() {
            return this.shouldRemap;
        }

        public String toString() {
            return "@" + this.getAnnotation().getAnnotationType().asElement().getSimpleName();
        }
    }
}

