/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.refmap;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.Launch;

public final class ReferenceMapper
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final String DEFAULT_RESOURCE = "mixin.refmap.json";
    public static final ReferenceMapper DEFAULT_MAPPER = new ReferenceMapper(true);
    private final Map<String, Map<String, String>> mappings = Maps.newHashMap();
    private final Map<String, Map<String, Map<String, String>>> data = Maps.newHashMap();
    private final transient boolean readOnly;
    private transient String context = null;

    public ReferenceMapper() {
        this(false);
    }

    private ReferenceMapper(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String remap(String className, String reference) {
        return this.remapWithContext(this.context, className, reference);
    }

    public String remapWithContext(String context, String className, String reference) {
        Map<String, Map<String, String>> mappings = this.mappings;
        if (context != null && (mappings = this.data.get(context)) == null) {
            mappings = this.mappings;
        }
        return this.remap(mappings, className, reference);
    }

    private String remap(Map<String, Map<String, String>> mappings, String className, String reference) {
        Map<String, String> classMappings;
        if (className == null) {
            for (Map<String, String> mapping : mappings.values()) {
                if (!mapping.containsKey(reference)) continue;
                return mapping.get(reference);
            }
        }
        if ((classMappings = mappings.get(className)) == null) {
            return reference;
        }
        String remappedReference = classMappings.get(reference);
        return remappedReference != null ? remappedReference : reference;
    }

    public String addMapping(String context, String className, String reference, String newReference) {
        Map<String, String> classMappings;
        if (this.readOnly || reference == null || newReference == null || reference.equals(newReference)) {
            return null;
        }
        HashMap mappings = this.mappings;
        if (context != null && (mappings = this.data.get(context)) == null) {
            mappings = Maps.newHashMap();
            this.data.put(context, mappings);
        }
        if ((classMappings = mappings.get(className)) == null) {
            classMappings = new HashMap<String, String>();
            mappings.put(className, classMappings);
        }
        return classMappings.put(reference, newReference);
    }

    public void write(Appendable writer) {
        new GsonBuilder().setPrettyPrinting().create().toJson((Object)this, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferenceMapper read(String resource) {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(Launch.classLoader.getResourceAsStream(resource));
            ReferenceMapper referenceMapper = ReferenceMapper.read(reader);
            return referenceMapper;
        }
        catch (Exception ex) {
            ReferenceMapper referenceMapper = DEFAULT_MAPPER;
            return referenceMapper;
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static ReferenceMapper read(Reader reader) {
        try {
            return (ReferenceMapper)new Gson().fromJson(reader, ReferenceMapper.class);
        }
        catch (Exception ex) {
            return DEFAULT_MAPPER;
        }
    }
}

