/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.tools.MirrorUtils;
import org.spongepowered.tools.obfuscation.FieldHandle;
import org.spongepowered.tools.obfuscation.MethodHandle;
import org.spongepowered.tools.obfuscation.TypeReference;

public class TypeHandle {
    private final String name;
    private final PackageElement pkg;
    private final TypeElement element;
    private TypeReference reference;

    public TypeHandle(PackageElement pkg, String name) {
        this.name = name.replace('.', '/');
        this.pkg = pkg;
        this.element = null;
    }

    public TypeHandle(TypeElement element) {
        this.pkg = MirrorUtils.getPackage(element);
        this.name = MirrorUtils.getInternalName(element);
        this.element = element;
    }

    public TypeHandle(DeclaredType type) {
        this((TypeElement)type.asElement());
    }

    public String toString() {
        return this.name.replace('/', '.');
    }

    public String getName() {
        return this.name;
    }

    public PackageElement getPackage() {
        return this.pkg;
    }

    public TypeElement getElement() {
        return this.element;
    }

    public List<? extends Element> getEnclosedElements() {
        return this.element != null ? this.element.getEnclosedElements() : Collections.emptyList();
    }

    public TypeMirror getType() {
        return this.element != null ? this.element.asType() : null;
    }

    public TypeHandle getSuperclass() {
        if (this.element == null) {
            return null;
        }
        TypeMirror superClass = this.element.getSuperclass();
        if (superClass == null || superClass.getKind() == TypeKind.NONE) {
            return null;
        }
        return new TypeHandle((DeclaredType)superClass);
    }

    public boolean isPublic() {
        return this.element != null ? this.element.getModifiers().contains((Object)Modifier.PUBLIC) : false;
    }

    public boolean isImaginary() {
        return this.element == null;
    }

    public TypeReference getReference() {
        if (this.reference == null) {
            this.reference = new TypeReference(this);
        }
        return this.reference;
    }

    public String findDescriptor(MemberInfo memberInfo) {
        String desc = memberInfo.desc;
        if (desc == null) {
            for (Element element : this.getEnclosedElements()) {
                if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().toString().equals(memberInfo.name)) continue;
                desc = MirrorUtils.generateSignature((ExecutableElement)element);
                break;
            }
        }
        return desc;
    }

    public FieldHandle findField(VariableElement element) {
        return this.findField(element, true);
    }

    public FieldHandle findField(VariableElement element, boolean caseSensitive) {
        return this.findField(element.getSimpleName().toString(), MirrorUtils.getTypeName(element.asType()), caseSensitive);
    }

    public FieldHandle findField(String name, String type) {
        return this.findField(name, type, true);
    }

    public FieldHandle findField(String name, String type, boolean caseSensitive) {
        String rawType = MirrorUtils.stripGenerics(type);
        for (Element element : this.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD) continue;
            VariableElement field = (VariableElement)element;
            if (this.compareElement(field, name, type, caseSensitive)) {
                return new FieldHandle(field);
            }
            if (!this.compareElement(field, name, rawType, caseSensitive)) continue;
            return new FieldHandle(field, true);
        }
        return null;
    }

    public MethodHandle findMethod(ExecutableElement element) {
        return this.findMethod(element, true);
    }

    public MethodHandle findMethod(ExecutableElement element, boolean caseSensitive) {
        return this.findMethod(element.getSimpleName().toString(), MirrorUtils.getJavaSignature(element), caseSensitive);
    }

    public MethodHandle findMethod(String name, String signature) {
        return this.findMethod(name, signature, true);
    }

    public MethodHandle findMethod(String name, String signature, boolean caseSensitive) {
        String rawSignature = MirrorUtils.stripGenerics(signature);
        for (Element element : this.getEnclosedElements()) {
            switch (element.getKind()) {
                case CONSTRUCTOR: 
                case METHOD: {
                    ExecutableElement method = (ExecutableElement)element;
                    if (!this.compareElement(method, name, signature, caseSensitive) && !this.compareElement(method, name, rawSignature, caseSensitive)) break;
                    return new MethodHandle(method);
                }
            }
        }
        return null;
    }

    private boolean compareElement(Element elem, String name, String type, boolean caseSensitive) {
        try {
            String elementName = elem.getSimpleName().toString();
            String elementType = MirrorUtils.getJavaSignature(elem);
            String rawElementType = MirrorUtils.stripGenerics(elementType);
            boolean compared = caseSensitive ? name.equals(elementName) : name.equalsIgnoreCase(elementName);
            return compared && (type.length() == 0 || type.equals(elementType) || type.equals(rawElementType));
        }
        catch (NullPointerException ex) {
            return false;
        }
    }
}

