/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.points;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.ListIterator;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;

public class BeforeNew
extends InjectionPoint {
    public static final String CODE = "NEW";
    private final String className;
    private final int ordinal;

    public BeforeNew(InjectionPointData data) {
        this.ordinal = data.getOrdinal();
        this.className = Strings.emptyToNull((String)data.get("class", data.get("target", "")).replace('.', '/'));
    }

    @Override
    public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes) {
        boolean found = false;
        int ordinal = 0;
        ListIterator<AbstractInsnNode> iter = insns.iterator();
        while (iter.hasNext()) {
            AbstractInsnNode insn = iter.next();
            if (!(insn instanceof TypeInsnNode) || insn.getOpcode() != 187 || !this.matchesOwner((TypeInsnNode)insn)) continue;
            if (this.ordinal == -1 || this.ordinal == ordinal) {
                nodes.add(insn);
                found = true;
            }
            ++ordinal;
        }
        return found;
    }

    private boolean matchesOwner(TypeInsnNode insn) {
        return this.className == null || this.className.equals(insn.desc);
    }
}

