/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.List;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.obfuscation.mapping.IMapping;
import org.spongepowered.asm.obfuscation.mapping.common.MappingField;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.tools.obfuscation.ObfuscationData;
import org.spongepowered.tools.obfuscation.ObfuscationEnvironment;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.TypeHandle;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IObfuscationDataProvider;

public class ObfuscationDataProvider
implements IObfuscationDataProvider {
    private final IMixinAnnotationProcessor ap;
    private final List<ObfuscationEnvironment> environments;

    public ObfuscationDataProvider(IMixinAnnotationProcessor ap, List<ObfuscationEnvironment> environments) {
        this.ap = ap;
        this.environments = environments;
    }

    @Override
    public <T> ObfuscationData<T> getObfEntryRecursive(MemberInfo targetMember) {
        MemberInfo currentTarget = targetMember;
        ObfuscationData<String> obfTargetNames = this.getObfClass(currentTarget.owner);
        ObfuscationData<IMapping<Object>> obfData = this.getObfEntry(currentTarget);
        try {
            while (obfData.isEmpty()) {
                TypeHandle targetType = this.ap.getTypeProvider().getTypeHandle(currentTarget.owner);
                if (targetType == null) {
                    return obfData;
                }
                TypeHandle superClass = targetType.getSuperclass();
                if (superClass == null) {
                    return obfData;
                }
                obfData = this.getObfEntry(currentTarget = currentTarget.move(superClass.getName()));
                if (obfData.isEmpty()) continue;
                for (ObfuscationType type : obfData) {
                    String obfClass = obfTargetNames.get(type);
                    T obfMember = obfData.get(type);
                    obfData.add(type, MemberInfo.fromMapping((IMapping)obfMember).move(obfClass).asMapping());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return this.getObfEntry(targetMember);
        }
        return obfData;
    }

    @Override
    public <T> ObfuscationData<T> getObfEntry(MemberInfo targetMember) {
        if (targetMember.isField()) {
            return this.getObfField(targetMember);
        }
        return this.getObfMethod(targetMember.asMethodMapping());
    }

    @Override
    public <T> ObfuscationData<T> getObfEntry(IMapping<T> mapping) {
        if (mapping != null) {
            if (mapping.getType() == IMapping.Type.FIELD) {
                return this.getObfField((MappingField)mapping);
            }
            if (mapping.getType() == IMapping.Type.METHOD) {
                return this.getObfMethod((MappingMethod)mapping);
            }
        }
        return new ObfuscationData();
    }

    @Override
    public ObfuscationData<MappingMethod> getObfMethodRecursive(MemberInfo targetMember) {
        return this.getObfEntryRecursive(targetMember);
    }

    @Override
    public ObfuscationData<MappingMethod> getObfMethod(MemberInfo method) {
        ObfuscationData<MappingMethod> data = new ObfuscationData<MappingMethod>();
        for (ObfuscationEnvironment env : this.environments) {
            MappingMethod obfMethod = env.getObfMethod(method);
            if (obfMethod == null) continue;
            data.add(env.getType(), obfMethod);
        }
        if (!data.isEmpty() || !"<init>".equals(method.name)) {
            return data;
        }
        return this.remapDescriptor(data, method);
    }

    @Override
    public ObfuscationData<MappingMethod> getObfMethod(MappingMethod method) {
        ObfuscationData<MappingMethod> data = new ObfuscationData<MappingMethod>();
        for (ObfuscationEnvironment env : this.environments) {
            MappingMethod obfMethod = env.getObfMethod(method);
            if (obfMethod == null) continue;
            data.add(env.getType(), obfMethod);
        }
        if (!data.isEmpty() || !"<init>".equals(method.getSimpleName())) {
            return data;
        }
        return this.remapDescriptor(data, new MemberInfo(method));
    }

    public ObfuscationData<MappingMethod> remapDescriptor(ObfuscationData<MappingMethod> data, MemberInfo method) {
        for (ObfuscationEnvironment env : this.environments) {
            MemberInfo obfMethod = env.remapDescriptor(method);
            if (obfMethod == null) continue;
            data.add(env.getType(), obfMethod.asMethodMapping());
        }
        return data;
    }

    @Override
    public ObfuscationData<MappingField> getObfFieldRecursive(MemberInfo targetMember) {
        return this.getObfEntryRecursive(targetMember);
    }

    @Override
    public ObfuscationData<MappingField> getObfField(MemberInfo field) {
        return this.getObfField(field.asFieldMapping());
    }

    @Override
    public ObfuscationData<MappingField> getObfField(MappingField field) {
        ObfuscationData<MappingField> data = new ObfuscationData<MappingField>();
        for (ObfuscationEnvironment env : this.environments) {
            MappingField obfField = env.getObfField(field);
            if (obfField == null) continue;
            if (obfField.getDesc() == null && field.getDesc() != null) {
                obfField = obfField.transform(env.remapDescriptor(field.getDesc()));
            }
            data.add(env.getType(), obfField);
        }
        return data;
    }

    @Override
    public ObfuscationData<String> getObfClass(TypeHandle type) {
        return this.getObfClass(type.getName());
    }

    @Override
    public ObfuscationData<String> getObfClass(String className) {
        ObfuscationData<String> data = new ObfuscationData<String>(className);
        for (ObfuscationEnvironment env : this.environments) {
            String obfClass = env.getObfClass(className);
            if (obfClass == null) continue;
            data.add(env.getType(), obfClass);
        }
        return data;
    }
}

