/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.meta.gson;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.spongepowered.plugin.meta.PluginMetadata;
import org.spongepowered.plugin.meta.gson.ModDependencyAdapter;

public final class ModMetadataAdapter
extends TypeAdapter<PluginMetadata> {
    public static final ModMetadataAdapter DEFAULT = new ModMetadataAdapter(new Gson(), ImmutableMap.of());
    private final Gson gson;
    private final ImmutableMap<String, Class<?>> extensions;

    public ModMetadataAdapter(Gson gson, ImmutableMap<String, Class<?>> extensions) {
        this.gson = gson;
        this.extensions = extensions;
    }

    public Gson getGson() {
        return this.gson;
    }

    public ImmutableMap<String, Class<?>> getExtensions() {
        return this.extensions;
    }

    public Class<?> getExtension(String key) {
        Class<Object> result = (Class<Object>)this.extensions.get((Object)key);
        return result != null ? result : Object.class;
    }

    public PluginMetadata read(JsonReader in) throws IOException {
        in.beginObject();
        HashSet<String> processedKeys = new HashSet<String>();
        PluginMetadata result = new PluginMetadata("unknown");
        String id = null;
        block22: while (in.hasNext()) {
            String name = in.nextName();
            if (!processedKeys.add(name)) {
                throw new JsonParseException("Duplicate key '" + name + "' in " + in);
            }
            switch (name) {
                case "modid": {
                    id = in.nextString();
                    result.setId(id);
                    continue block22;
                }
                case "name": {
                    result.setName(in.nextString());
                    continue block22;
                }
                case "version": {
                    result.setVersion(in.nextString());
                    continue block22;
                }
                case "description": {
                    result.setDescription(in.nextString());
                    continue block22;
                }
                case "url": {
                    result.setUrl(in.nextString());
                    continue block22;
                }
                case "authorList": {
                    in.beginArray();
                    while (in.hasNext()) {
                        result.addAuthor(in.nextString());
                    }
                    in.endArray();
                    continue block22;
                }
                case "requiredMods": {
                    in.beginArray();
                    while (in.hasNext()) {
                        result.addRequiredDependency(ModDependencyAdapter.INSTANCE.read(in));
                    }
                    in.endArray();
                    continue block22;
                }
                case "dependencies": {
                    in.beginArray();
                    while (in.hasNext()) {
                        result.loadAfter(ModDependencyAdapter.INSTANCE.read(in));
                    }
                    in.endArray();
                    continue block22;
                }
                case "dependants": {
                    in.beginArray();
                    while (in.hasNext()) {
                        result.loadBefore(ModDependencyAdapter.INSTANCE.read(in));
                    }
                    in.endArray();
                    continue block22;
                }
            }
            result.setExtension(name, this.gson.fromJson(in, this.getExtension(name)));
        }
        in.endObject();
        if (id == null) {
            throw new JsonParseException("Mod metadata is missing required element 'modid'");
        }
        return result;
    }

    public void write(JsonWriter out, PluginMetadata meta) throws IOException {
        out.beginObject();
        out.name("modid").value(meta.getId());
        ModMetadataAdapter.writeIfPresent(out, "name", meta.getName());
        ModMetadataAdapter.writeIfPresent(out, "version", meta.getVersion());
        ModMetadataAdapter.writeIfPresent(out, "description", meta.getDescription());
        ModMetadataAdapter.writeIfPresent(out, "url", meta.getUrl());
        if (!meta.getAuthors().isEmpty()) {
            out.name("authorList").beginArray();
            for (String string : meta.getAuthors()) {
                out.value(string);
            }
            out.endArray();
        }
        ModMetadataAdapter.writeDependencies(out, "requiredMods", meta.getRequiredDependencies());
        ModMetadataAdapter.writeDependencies(out, "dependencies", meta.getLoadAfter());
        ModMetadataAdapter.writeDependencies(out, "dependants", meta.getLoadBefore());
        if (!meta.getExtensions().isEmpty()) {
            for (Map.Entry entry : meta.getExtensions().entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                out.name(key);
                this.gson.toJson(value, this.getExtension(key), out);
            }
        }
        out.endObject();
    }

    private static void writeIfPresent(JsonWriter out, String key, String value) throws IOException {
        if (value != null) {
            out.name(key).value(value);
        }
    }

    private static void writeDependencies(JsonWriter out, String key, Set<PluginMetadata.Dependency> dependencies) throws IOException {
        if (!dependencies.isEmpty()) {
            out.name(key).beginArray();
            for (PluginMetadata.Dependency dependency : dependencies) {
                ModDependencyAdapter.INSTANCE.write(out, dependency);
            }
            out.endArray();
        }
    }
}

