/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.value.ValueFactory;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.ai.task.AITaskType;
import org.spongepowered.api.entity.ai.task.AbstractAITask;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.merchant.VillagerRegistry;
import org.spongepowered.api.item.recipe.RecipeRegistry;
import org.spongepowered.api.network.status.Favicon;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.RegistryModule;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.statistic.BlockStatistic;
import org.spongepowered.api.statistic.EntityStatistic;
import org.spongepowered.api.statistic.ItemStatistic;
import org.spongepowered.api.statistic.Statistic;
import org.spongepowered.api.statistic.StatisticGroup;
import org.spongepowered.api.statistic.TeamStatistic;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.selector.SelectorFactory;
import org.spongepowered.api.text.serializer.TextSerializerFactory;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.util.rotation.Rotation;
import org.spongepowered.api.world.extent.ExtentBufferFactory;

public interface GameRegistry {
    public <T extends CatalogType> Optional<T> getType(Class<T> var1, String var2);

    public <T extends CatalogType> Collection<T> getAllOf(Class<T> var1);

    public <T extends CatalogType> Collection<T> getAllFor(String var1, Class<T> var2);

    default public <T extends CatalogType> Collection<T> getAllForMinecraft(Class<T> typeClass) {
        return this.getAllFor("minecraft", typeClass);
    }

    default public <T extends CatalogType> Collection<T> getAllForSponge(Class<T> typeClass) {
        return this.getAllFor("sponge", typeClass);
    }

    public <T extends CatalogType> GameRegistry registerModule(Class<T> var1, CatalogRegistryModule<T> var2) throws IllegalArgumentException, UnsupportedOperationException;

    public GameRegistry registerModule(RegistryModule var1) throws IllegalArgumentException, UnsupportedOperationException;

    public <T> GameRegistry registerBuilderSupplier(Class<T> var1, Supplier<? extends T> var2);

    public <T extends ResettableBuilder<?, ? super T>> T createBuilder(Class<T> var1) throws IllegalArgumentException;

    public <T extends CatalogType> void register(Class<T> var1, T var2) throws IllegalArgumentException, UnsupportedOperationException;

    public Collection<String> getDefaultGameRules();

    public Optional<EntityStatistic> getEntityStatistic(StatisticGroup var1, EntityType var2);

    public Optional<ItemStatistic> getItemStatistic(StatisticGroup var1, ItemType var2);

    public Optional<BlockStatistic> getBlockStatistic(StatisticGroup var1, BlockType var2);

    public Optional<TeamStatistic> getTeamStatistic(StatisticGroup var1, TextColor var2);

    public Collection<Statistic> getStatistics(StatisticGroup var1);

    public Optional<Rotation> getRotationFromDegree(int var1);

    public Favicon loadFavicon(String var1) throws IOException;

    public Favicon loadFavicon(Path var1) throws IOException;

    public Favicon loadFavicon(URL var1) throws IOException;

    public Favicon loadFavicon(InputStream var1) throws IOException;

    public Favicon loadFavicon(BufferedImage var1) throws IOException;

    public RecipeRegistry getRecipeRegistry();

    public Optional<ResourcePack> getResourcePackById(String var1);

    public Optional<DisplaySlot> getDisplaySlotForColor(TextColor var1);

    public AITaskType registerAITaskType(Object var1, String var2, String var3, Class<? extends AbstractAITask<? extends Agent>> var4);

    public ExtentBufferFactory getExtentBufferFactory();

    public ValueFactory getValueFactory();

    public VillagerRegistry getVillagerRegistry();

    @Deprecated
    public TextSerializerFactory getTextSerializerFactory();

    @Deprecated
    public SelectorFactory getSelectorFactory();

    public Locale getLocale(String var1);

    public Optional<Translation> getTranslationById(String var1);
}

