/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.profile.GameProfileManager;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.world.ChunkTicketManager;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldCreationSettings;
import org.spongepowered.api.world.storage.ChunkLayout;
import org.spongepowered.api.world.storage.WorldProperties;

public interface Server {
    public Collection<Player> getOnlinePlayers();

    public int getMaxPlayers();

    public Optional<Player> getPlayer(UUID var1);

    public Optional<Player> getPlayer(String var1);

    public Collection<World> getWorlds();

    public Collection<WorldProperties> getUnloadedWorlds();

    public Collection<WorldProperties> getAllWorldProperties();

    public Optional<World> getWorld(UUID var1);

    public Optional<World> getWorld(String var1);

    public Optional<WorldProperties> getDefaultWorld();

    public String getDefaultWorldName();

    public Optional<World> loadWorld(String var1);

    public Optional<World> loadWorld(UUID var1);

    public Optional<World> loadWorld(WorldProperties var1);

    public Optional<WorldProperties> getWorldProperties(String var1);

    public Optional<WorldProperties> getWorldProperties(UUID var1);

    public boolean unloadWorld(World var1);

    public Optional<WorldProperties> createWorldProperties(WorldCreationSettings var1);

    public CompletableFuture<Optional<WorldProperties>> copyWorld(WorldProperties var1, String var2);

    public Optional<WorldProperties> renameWorld(WorldProperties var1, String var2);

    public CompletableFuture<Boolean> deleteWorld(WorldProperties var1);

    public boolean saveWorldProperties(WorldProperties var1);

    public Optional<Scoreboard> getServerScoreboard();

    public ChunkLayout getChunkLayout();

    public int getRunningTimeTicks();

    public MessageChannel getBroadcastChannel();

    public void setBroadcastChannel(MessageChannel var1);

    public Optional<InetSocketAddress> getBoundAddress();

    public boolean hasWhitelist();

    public void setHasWhitelist(boolean var1);

    public boolean getOnlineMode();

    public Text getMotd();

    public void shutdown();

    public void shutdown(Text var1);

    public ConsoleSource getConsole();

    public ChunkTicketManager getChunkTicketManager();

    public GameProfileManager getGameProfileManager();

    public double getTicksPerSecond();

    public Optional<ResourcePack> getDefaultResourcePack();

    public int getPlayerIdleTimeout();

    public void setPlayerIdleTimeout(int var1);
}

