/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.asset;

import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.spongepowered.api.plugin.PluginContainer;

public interface Asset {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    public PluginContainer getOwner();

    public URL getUrl();

    default public void copyToFile(Path output) throws IOException {
        Preconditions.checkNotNull((Object)output, (Object)"output");
        try (InputStream in = this.getUrl().openStream();){
            Files.copy(in, output, new CopyOption[0]);
        }
    }

    default public String readString() throws IOException {
        return this.readString(DEFAULT_CHARSET);
    }

    default public String readString(Charset charset) throws IOException {
        Preconditions.checkNotNull((Object)charset, (Object)"charset");
        return Resources.toString((URL)this.getUrl(), (Charset)charset);
    }

    default public List<String> readLines() throws IOException {
        return this.readLines(DEFAULT_CHARSET);
    }

    default public List<String> readLines(Charset charset) throws IOException {
        Preconditions.checkNotNull((Object)charset, (Object)"charset");
        return Resources.asCharSource((URL)this.getUrl(), (Charset)charset).readLines();
    }

    default public byte[] readBytes() throws IOException {
        return Resources.toByteArray((URL)this.getUrl());
    }
}

