/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command;

import java.util.Optional;
import javax.annotation.Nullable;

public class CommandResult {
    private static final CommandResult EMPTY = CommandResult.builder().build();
    private static final CommandResult SUCCESS = CommandResult.builder().successCount(1).build();
    private final Optional<Integer> successCount;
    private final Optional<Integer> affectedBlocks;
    private final Optional<Integer> affectedEntities;
    private final Optional<Integer> affectedItems;
    private final Optional<Integer> queryResult;

    public static Builder builder() {
        return new Builder();
    }

    public static CommandResult empty() {
        return EMPTY;
    }

    public static CommandResult success() {
        return SUCCESS;
    }

    CommandResult(@Nullable Integer successCount, @Nullable Integer affectedBlocks, @Nullable Integer affectedEntities, @Nullable Integer affectedItems, @Nullable Integer queryResult) {
        this.successCount = Optional.ofNullable(successCount);
        this.affectedBlocks = Optional.ofNullable(affectedBlocks);
        this.affectedEntities = Optional.ofNullable(affectedEntities);
        this.affectedItems = Optional.ofNullable(affectedItems);
        this.queryResult = Optional.ofNullable(queryResult);
    }

    public Optional<Integer> getSuccessCount() {
        return this.successCount;
    }

    public Optional<Integer> getAffectedBlocks() {
        return this.affectedBlocks;
    }

    public Optional<Integer> getAffectedEntities() {
        return this.affectedEntities;
    }

    public Optional<Integer> getAffectedItems() {
        return this.affectedItems;
    }

    public Optional<Integer> getQueryResult() {
        return this.queryResult;
    }

    public static class Builder {
        @Nullable
        private Integer successCount;
        @Nullable
        private Integer affectedBlocks;
        @Nullable
        private Integer affectedEntities;
        @Nullable
        private Integer affectedItems;
        @Nullable
        private Integer queryResult;

        Builder() {
        }

        public Builder successCount(@Nullable Integer successCount) {
            this.successCount = successCount;
            return this;
        }

        public Builder affectedBlocks(@Nullable Integer affectedBlocks) {
            this.affectedBlocks = affectedBlocks;
            return this;
        }

        public Builder affectedEntities(@Nullable Integer affectedEntities) {
            this.affectedEntities = affectedEntities;
            return this;
        }

        public Builder affectedItems(@Nullable Integer affectedItems) {
            this.affectedItems = affectedItems;
            return this;
        }

        public Builder queryResult(@Nullable Integer queryResult) {
            this.queryResult = queryResult;
            return this;
        }

        public CommandResult build() {
            return new CommandResult(this.successCount, this.affectedBlocks, this.affectedEntities, this.affectedItems, this.queryResult);
        }
    }
}

