/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.spec;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandPermissionException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.ChildCommandElementExecutor;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.args.parsing.InputTokenizer;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.SpongeApiTranslationHelper;

public final class CommandSpec
implements CommandCallable {
    private final CommandElement args;
    private final CommandExecutor executor;
    private final Optional<Text> description;
    @Nullable
    private final Text extendedDescription;
    @Nullable
    private final String permission;
    private final InputTokenizer argumentParser;

    CommandSpec(CommandElement args, CommandExecutor executor, @Nullable Text description, @Nullable Text extendedDescription, @Nullable String permission, InputTokenizer parser) {
        this.args = args;
        this.executor = executor;
        this.permission = permission;
        this.description = Optional.ofNullable(description);
        this.extendedDescription = extendedDescription;
        this.argumentParser = parser;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void checkPermission(CommandSource source) throws CommandException {
        Preconditions.checkNotNull((Object)source, (Object)"source");
        if (!this.testPermission(source)) {
            throw new CommandPermissionException();
        }
    }

    public void populateContext(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
        this.args.parse(source, args, context);
        if (args.hasNext()) {
            args.next();
            throw args.createError(SpongeApiTranslationHelper.t("Too many arguments!", new Object[0]));
        }
    }

    public List<String> complete(CommandSource source, CommandArgs args, CommandContext context) {
        Preconditions.checkNotNull((Object)source, (Object)"source");
        List<String> ret = this.args.complete(source, args, context);
        return ret == null ? ImmutableList.of() : ImmutableList.copyOf(ret);
    }

    public CommandExecutor getExecutor() {
        return this.executor;
    }

    public InputTokenizer getInputTokenizer() {
        return this.argumentParser;
    }

    @Override
    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        this.checkPermission(source);
        CommandArgs args = new CommandArgs(arguments, this.getInputTokenizer().tokenize(arguments, false));
        CommandContext context = new CommandContext();
        this.populateContext(source, args, context);
        return this.getExecutor().execute(source, context);
    }

    @Override
    public List<String> getSuggestions(CommandSource source, String arguments) throws CommandException {
        CommandArgs args = new CommandArgs(arguments, this.getInputTokenizer().tokenize(arguments, true));
        return this.complete(source, args, new CommandContext());
    }

    @Override
    public boolean testPermission(CommandSource source) {
        return this.permission == null || source.hasPermission(this.permission);
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        return this.description;
    }

    @Override
    public Text getUsage(CommandSource source) {
        Preconditions.checkNotNull((Object)source, (Object)"source");
        return this.args.getUsage(source);
    }

    public Optional<Text> getHelp(CommandSource source) {
        Preconditions.checkNotNull((Object)source, (Object)"source");
        Text.Builder builder = Text.builder();
        Optional<Text> desc = this.getShortDescription(source);
        if (desc.isPresent()) {
            builder.append(desc.get(), Text.NEW_LINE);
        }
        builder.append(this.getUsage(source));
        if (this.extendedDescription != null) {
            builder.append(Text.NEW_LINE, this.extendedDescription);
        }
        return Optional.of(builder.build());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandSpec that = (CommandSpec)o;
        return Objects.equal((Object)this.args, (Object)that.args) && Objects.equal((Object)this.executor, (Object)that.executor) && Objects.equal(this.description, that.description) && Objects.equal((Object)this.extendedDescription, (Object)that.extendedDescription) && Objects.equal((Object)this.permission, (Object)that.permission) && Objects.equal((Object)this.argumentParser, (Object)that.argumentParser);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.args, this.executor, this.description, this.extendedDescription, this.permission, this.argumentParser});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("args", (Object)this.args).add("executor", (Object)this.executor).add("description", this.description).add("extendedDescription", (Object)this.extendedDescription).add("permission", (Object)this.permission).add("argumentParser", (Object)this.argumentParser).toString();
    }

    public static final class Builder {
        private static final CommandElement DEFAULT_ARG = GenericArguments.none();
        private CommandElement args = DEFAULT_ARG;
        @Nullable
        private Text description;
        @Nullable
        private Text extendedDescription;
        @Nullable
        private String permission;
        @Nullable
        private CommandExecutor executor;
        @Nullable
        private Map<List<String>, CommandCallable> childCommandMap;
        private InputTokenizer argumentParser = InputTokenizer.quotedStrings(false);

        Builder() {
        }

        public Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        public Builder executor(CommandExecutor executor) {
            Preconditions.checkNotNull((Object)executor, (Object)"executor");
            this.executor = executor;
            return this;
        }

        public Builder children(Map<List<String>, ? extends CommandCallable> children) {
            Preconditions.checkNotNull(children, (Object)"children");
            if (this.childCommandMap == null) {
                this.childCommandMap = new HashMap<List<String>, CommandCallable>();
            }
            this.childCommandMap.putAll(children);
            return this;
        }

        public Builder child(CommandCallable child, String ... aliases) {
            if (this.childCommandMap == null) {
                this.childCommandMap = new HashMap<List<String>, CommandCallable>();
            }
            this.childCommandMap.put((List<String>)ImmutableList.copyOf((Object[])aliases), child);
            return this;
        }

        public Builder description(@Nullable Text description) {
            this.description = description;
            return this;
        }

        public Builder extendedDescription(@Nullable Text extendedDescription) {
            this.extendedDescription = extendedDescription;
            return this;
        }

        public Builder arguments(CommandElement args) {
            Preconditions.checkNotNull((Object)args, (Object)"args");
            this.args = args;
            return this;
        }

        public Builder arguments(CommandElement ... args) {
            Preconditions.checkNotNull((Object)args, (Object)"args");
            this.args = GenericArguments.seq(args);
            return this;
        }

        public Builder inputTokenizer(InputTokenizer parser) {
            Preconditions.checkNotNull((Object)parser, (Object)"parser");
            this.argumentParser = parser;
            return this;
        }

        public CommandSpec build() {
            if (this.childCommandMap == null) {
                Preconditions.checkNotNull((Object)this.executor, (Object)"An executor is required");
            } else {
                ChildCommandElementExecutor childDispatcher = new ChildCommandElementExecutor(this.executor);
                for (Map.Entry<List<String>, CommandCallable> spec : this.childCommandMap.entrySet()) {
                    childDispatcher.register(spec.getValue(), spec.getKey());
                }
                if (this.args == DEFAULT_ARG) {
                    this.arguments(this.executor == null ? childDispatcher : GenericArguments.optional(childDispatcher));
                } else if (this.executor == null) {
                    this.arguments(this.args, childDispatcher);
                } else {
                    this.arguments(GenericArguments.firstParsing(childDispatcher, this.args));
                }
                this.executor(childDispatcher);
            }
            return new CommandSpec(this.args, this.executor, this.description, this.extendedDescription, this.permission, this.argumentParser);
        }
    }
}

