/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataManager;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.persistence.DataSerializer;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.util.Coerce;

public class MemoryDataView
implements DataView {
    protected final Map<String, Object> map = Maps.newLinkedHashMap();
    private final DataContainer container;
    private final DataView parent;
    private final DataQuery path;

    protected MemoryDataView() {
        Preconditions.checkState((boolean)(this instanceof DataContainer), (Object)"Cannot construct a root MemoryDataView without a container!");
        this.path = DataQuery.of();
        this.parent = this;
        this.container = (DataContainer)((Object)this);
    }

    protected MemoryDataView(DataView parent, DataQuery path) {
        Preconditions.checkArgument((path.getParts().size() >= 1 ? 1 : 0) != 0, (Object)"Path must have at least one part");
        this.parent = parent;
        this.container = parent.getContainer();
        this.path = parent.getCurrentPath().then(path);
    }

    @Override
    public DataContainer getContainer() {
        return this.container;
    }

    @Override
    public DataQuery getCurrentPath() {
        return this.path;
    }

    @Override
    public String getName() {
        List<String> parts = this.path.getParts();
        return parts.isEmpty() ? "" : parts.get(parts.size() - 1);
    }

    @Override
    public Optional<DataView> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public Set<DataQuery> getKeys(boolean deep) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            builder.add((Object)DataQuery.of(entry.getKey()));
        }
        if (deep) {
            for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                if (!(entry.getValue() instanceof DataView)) continue;
                for (DataQuery query : ((DataView)entry.getValue()).getKeys(true)) {
                    builder.add((Object)DataQuery.of(entry.getKey()).then(query));
                }
            }
        }
        return builder.build();
    }

    @Override
    public Map<DataQuery, Object> getValues(boolean deep) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DataQuery query : this.getKeys(deep)) {
            Object value = this.get(query).get();
            if (value instanceof DataView) {
                builder.put((Object)query, ((DataView)value).getValues(deep));
                continue;
            }
            builder.put((Object)query, this.get(query).get());
        }
        return builder.build();
    }

    @Override
    public final boolean contains(DataQuery path) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        List<DataQuery> queryParts = path.getQueryParts();
        if (queryParts.size() == 1) {
            String key = queryParts.get(0).getParts().get(0);
            return this.map.containsKey(key);
        }
        DataQuery subQuery = queryParts.get(0);
        Optional<DataView> subViewOptional = this.getUnsafeView(subQuery);
        if (!subViewOptional.isPresent()) {
            return false;
        }
        ArrayList subParts = Lists.newArrayListWithCapacity((int)(queryParts.size() - 1));
        for (int i = 1; i < queryParts.size(); ++i) {
            subParts.add(queryParts.get(i).asString("."));
        }
        return subViewOptional.get().contains(DataQuery.of(subParts));
    }

    @Override
    public boolean contains(DataQuery path, DataQuery ... paths) {
        Preconditions.checkNotNull((Object)path, (Object)"DataQuery cannot be null!");
        Preconditions.checkNotNull((Object)paths, (Object)"DataQuery varargs cannot be null!");
        if (paths.length == 0) {
            return this.contains(path);
        }
        ArrayList<Object> queries = new ArrayList<Object>();
        queries.add(path);
        for (DataQuery query : paths) {
            queries.add(Preconditions.checkNotNull((Object)query, (Object)"No null queries!"));
        }
        for (DataQuery dataQuery : queries) {
            if (this.contains(dataQuery)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Optional<Object> get(DataQuery path) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        List<DataQuery> queryParts = path.getQueryParts();
        int sz = queryParts.size();
        if (sz == 0) {
            return Optional.of(this);
        }
        if (sz == 1) {
            String key = queryParts.get(0).getParts().get(0);
            if (this.map.containsKey(key)) {
                Object object = this.map.get(key);
                if (object.getClass().isArray()) {
                    if (object instanceof byte[]) {
                        return Optional.of(ArrayUtils.clone((byte[])((byte[])object)));
                    }
                    if (object instanceof short[]) {
                        return Optional.of(ArrayUtils.clone((short[])((short[])object)));
                    }
                    if (object instanceof int[]) {
                        return Optional.of(ArrayUtils.clone((int[])((int[])object)));
                    }
                    if (object instanceof long[]) {
                        return Optional.of(ArrayUtils.clone((long[])((long[])object)));
                    }
                    if (object instanceof float[]) {
                        return Optional.of(ArrayUtils.clone((float[])((float[])object)));
                    }
                    if (object instanceof double[]) {
                        return Optional.of(ArrayUtils.clone((double[])((double[])object)));
                    }
                    if (object instanceof boolean[]) {
                        return Optional.of(ArrayUtils.clone((boolean[])((boolean[])object)));
                    }
                    return Optional.of(ArrayUtils.clone((Object[])((Object[])object)));
                }
                return Optional.of(this.map.get(key));
            }
            return Optional.empty();
        }
        DataQuery subQuery = queryParts.get(0);
        Optional<DataView> subViewOptional = this.getUnsafeView(subQuery);
        if (!subViewOptional.isPresent()) {
            return Optional.empty();
        }
        DataView subView = subViewOptional.get();
        ArrayList subParts = Lists.newArrayListWithCapacity((int)(queryParts.size() - 1));
        for (int i = 1; i < queryParts.size(); ++i) {
            subParts.add(queryParts.get(i).asString("."));
        }
        return subView.get(DataQuery.of(subParts));
    }

    @Override
    public DataView set(DataQuery path, Object value) {
        DataManager manager;
        Preconditions.checkNotNull((Object)path, (Object)"path");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        Preconditions.checkState((this.container != null ? 1 : 0) != 0);
        try {
            manager = Sponge.getDataManager();
        }
        catch (Exception e) {
            manager = null;
        }
        if (value instanceof DataView) {
            Preconditions.checkArgument((value != this ? 1 : 0) != 0, (Object)"Cannot set a DataView to itself.");
            this.copyDataView(path, (DataView)value);
        } else if (value instanceof DataSerializable) {
            DataContainer valueContainer = ((DataSerializable)value).toContainer();
            Preconditions.checkArgument((!valueContainer.equals(this) ? 1 : 0) != 0, (Object)"Cannot insert self-referencing DataSerializable");
            this.copyDataView(path, valueContainer);
        } else {
            if (value instanceof CatalogType) {
                return this.set(path, ((CatalogType)value).getId());
            }
            if (manager != null && manager.getSerializer(value.getClass()).isPresent()) {
                DataSerializer<?> serializer = manager.getSerializer(value.getClass()).get();
                DataContainer container = serializer.serialize(value);
                Preconditions.checkArgument((!container.equals(this) ? 1 : 0) != 0, (Object)"Cannot insert self-referencing Objects!");
                this.copyDataView(path, container);
            } else {
                List<String> parts = path.getParts();
                if (parts.size() > 1) {
                    DataView subView;
                    String subKey = parts.get(0);
                    DataQuery subQuery = DataQuery.of(subKey);
                    Optional<DataView> subViewOptional = this.getUnsafeView(subQuery);
                    if (!subViewOptional.isPresent()) {
                        this.createView(subQuery);
                        subView = (DataView)this.map.get(subKey);
                    } else {
                        subView = subViewOptional.get();
                    }
                    ArrayList subParts = Lists.newArrayListWithCapacity((int)(parts.size() - 1));
                    for (int i = 1; i < parts.size(); ++i) {
                        subParts.add(parts.get(i));
                    }
                    subView.set(DataQuery.of(subParts), value);
                } else if (value instanceof Collection) {
                    this.setCollection(parts.get(0), (Collection)value);
                } else if (value instanceof Map) {
                    this.setMap(parts.get(0), (Map)value);
                } else if (value.getClass().isArray()) {
                    if (value instanceof byte[]) {
                        this.map.put(parts.get(0), ArrayUtils.clone((byte[])((byte[])value)));
                    } else if (value instanceof short[]) {
                        this.map.put(parts.get(0), ArrayUtils.clone((short[])((short[])value)));
                    } else if (value instanceof int[]) {
                        this.map.put(parts.get(0), ArrayUtils.clone((int[])((int[])value)));
                    } else if (value instanceof long[]) {
                        this.map.put(parts.get(0), ArrayUtils.clone((long[])((long[])value)));
                    } else if (value instanceof float[]) {
                        this.map.put(parts.get(0), ArrayUtils.clone((float[])((float[])value)));
                    } else if (value instanceof double[]) {
                        this.map.put(parts.get(0), ArrayUtils.clone((double[])((double[])value)));
                    } else if (value instanceof boolean[]) {
                        this.map.put(parts.get(0), ArrayUtils.clone((boolean[])((boolean[])value)));
                    } else {
                        this.map.put(parts.get(0), ArrayUtils.clone((Object[])((Object[])value)));
                    }
                } else {
                    this.map.put(parts.get(0), value);
                }
            }
        }
        return this;
    }

    @Override
    public <E> DataView set(Key<? extends BaseValue<E>> key, E value) {
        return this.set(((Key)Preconditions.checkNotNull(key, (Object)"Key was null!")).getQuery(), value);
    }

    private void setCollection(String key, Collection<?> value) {
        DataManager manager;
        ImmutableList.Builder builder = ImmutableList.builder();
        try {
            manager = Sponge.getDataManager();
        }
        catch (Exception e) {
            manager = null;
        }
        for (Object object : value) {
            if (object instanceof DataSerializable) {
                builder.add((Object)((DataSerializable)object).toContainer());
                continue;
            }
            if (object instanceof DataView) {
                MemoryDataContainer view = new MemoryDataContainer();
                DataView internalView = (DataView)object;
                for (Map.Entry<DataQuery, Object> entry : internalView.getValues(false).entrySet()) {
                    ((MemoryDataView)view).set(entry.getKey(), entry.getValue());
                }
                builder.add((Object)view);
                continue;
            }
            if (object instanceof Map) {
                builder.add(this.ensureSerialization((Map)object));
                continue;
            }
            if (object instanceof Collection) {
                builder.add(this.ensureSerialization((Collection)object));
                continue;
            }
            if (manager != null) {
                Optional<DataSerializer<?>> serializerOptional = manager.getSerializer(object.getClass());
                if (serializerOptional.isPresent()) {
                    DataSerializer<?> serializer = serializerOptional.get();
                    DataContainer container = serializer.serialize(value);
                    Preconditions.checkArgument((!container.equals(this) ? 1 : 0) != 0, (Object)"Cannot insert self-referencing Objects!");
                    this.copyDataView(this.path, container);
                    continue;
                }
                builder.add(object);
                continue;
            }
            builder.add(object);
        }
        this.map.put(key, builder.build());
    }

    private ImmutableList<Object> ensureSerialization(Collection<?> collection) {
        ImmutableList.Builder objectBuilder = ImmutableList.builder();
        collection.forEach(element -> {
            if (element instanceof Collection) {
                objectBuilder.add(this.ensureSerialization((Collection)element));
            } else if (element instanceof DataSerializable) {
                objectBuilder.add((Object)((DataSerializable)element).toContainer());
            } else {
                objectBuilder.add(element);
            }
        });
        return objectBuilder.build();
    }

    private ImmutableMap<?, ?> ensureSerialization(Map<?, ?> map) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.entrySet().forEach(entry -> {
            if (entry.getValue() instanceof Map) {
                builder.put(entry.getKey(), this.ensureSerialization((Map)entry.getValue()));
            } else if (entry.getValue() instanceof DataSerializable) {
                builder.put(entry.getKey(), (Object)((DataSerializable)entry.getValue()).toContainer());
            } else if (entry.getValue() instanceof Collection) {
                builder.put(entry.getKey(), this.ensureSerialization((Collection)entry.getValue()));
            } else {
                builder.put(entry.getKey(), entry.getValue());
            }
        });
        return builder.build();
    }

    private void setMap(String key, Map<?, ?> value) {
        DataView view = this.createView(DataQuery.of(key));
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            view.set(DataQuery.of(entry.getKey().toString()), entry.getValue());
        }
    }

    private void copyDataView(DataQuery path, DataView value) {
        Set<DataQuery> valueKeys = value.getKeys(true);
        for (DataQuery oldKey : valueKeys) {
            this.set(path.then(oldKey), value.get(oldKey).get());
        }
    }

    @Override
    public DataView remove(DataQuery path) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        List<String> parts = path.getParts();
        if (parts.size() > 1) {
            String subKey = parts.get(0);
            DataQuery subQuery = DataQuery.of(subKey);
            Optional<DataView> subViewOptional = this.getUnsafeView(subQuery);
            if (!subViewOptional.isPresent()) {
                return this;
            }
            DataView subView = subViewOptional.get();
            ArrayList subParts = Lists.newArrayListWithCapacity((int)(parts.size() - 1));
            for (int i = 1; i < parts.size(); ++i) {
                subParts.add(parts.get(i));
            }
            subView.remove(DataQuery.of(subParts));
        } else {
            this.map.remove(parts.get(0));
        }
        return this;
    }

    @Override
    public DataView createView(DataQuery path) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        List<DataQuery> queryParts = path.getQueryParts();
        int sz = queryParts.size();
        Preconditions.checkArgument((sz != 0 ? 1 : 0) != 0, (Object)"The size of the query must be at least 1");
        if (sz == 1) {
            DataQuery key = queryParts.get(0);
            MemoryDataView result = new MemoryDataView(this, key);
            this.map.put(key.getParts().get(0), result);
            return result;
        }
        ArrayList subParts = Lists.newArrayListWithCapacity((int)(queryParts.size() - 1));
        for (int i = 1; i < sz; ++i) {
            subParts.add(queryParts.get(i).asString('.'));
        }
        DataQuery subQuery = DataQuery.of(subParts);
        DataView subView = (DataView)this.map.get(queryParts.get(0).asString('.'));
        if (subView == null) {
            subView = new MemoryDataView(this.parent, queryParts.get(0));
            this.map.put(queryParts.get(0).asString('.'), subView);
        }
        return subView.createView(subQuery);
    }

    @Override
    public DataView createView(DataQuery path, Map<?, ?> map) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        DataView section = this.createView(path);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                section.createView(DataQuery.of('.', entry.getKey().toString()), (Map)entry.getValue());
                continue;
            }
            section.set(DataQuery.of('.', entry.getKey().toString()), entry.getValue());
        }
        return section;
    }

    @Override
    public Optional<DataView> getView(DataQuery path) {
        return this.get(path).filter(obj -> obj instanceof DataView).map(obj -> (DataView)obj);
    }

    @Override
    public Optional<? extends Map<?, ?>> getMap(DataQuery path) {
        Optional<Object> val = this.get(path);
        if (val.isPresent()) {
            if (val.get() instanceof DataView) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry<DataQuery, Object> entry : ((DataView)val.get()).getValues(false).entrySet()) {
                    builder.put((Object)entry.getKey().asString('.'), this.ensureMappingOf(entry.getValue()));
                }
                return Optional.of(builder.build());
            }
            if (val.get() instanceof Map) {
                return Optional.of((Map)this.ensureMappingOf(val.get()));
            }
        }
        return Optional.empty();
    }

    private Object ensureMappingOf(Object object) {
        if (object instanceof DataView) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<DataQuery, Object> entry : ((DataView)object).getValues(false).entrySet()) {
                builder.put((Object)entry.getKey().asString('.'), this.ensureMappingOf(entry.getValue()));
            }
            return builder.build();
        }
        if (object instanceof Map) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                builder.put((Object)entry.getKey().toString(), this.ensureMappingOf(entry.getValue()));
            }
            return builder.build();
        }
        if (object instanceof Collection) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object entry : (Collection)object) {
                builder.add(this.ensureMappingOf(entry));
            }
            return builder.build();
        }
        return object;
    }

    private Optional<DataView> getUnsafeView(DataQuery path) {
        return this.get(path).filter(obj -> obj instanceof DataView).map(obj -> (DataView)obj);
    }

    @Override
    public Optional<Boolean> getBoolean(DataQuery path) {
        return this.get(path).flatMap(Coerce::asBoolean);
    }

    @Override
    public Optional<Byte> getByte(DataQuery path) {
        return this.get(path).flatMap(Coerce::asByte);
    }

    @Override
    public Optional<Short> getShort(DataQuery path) {
        return this.get(path).flatMap(Coerce::asShort);
    }

    @Override
    public Optional<Integer> getInt(DataQuery path) {
        return this.get(path).flatMap(Coerce::asInteger);
    }

    @Override
    public Optional<Long> getLong(DataQuery path) {
        return this.get(path).flatMap(Coerce::asLong);
    }

    @Override
    public Optional<Float> getFloat(DataQuery path) {
        return this.get(path).flatMap(Coerce::asFloat);
    }

    @Override
    public Optional<Double> getDouble(DataQuery path) {
        return this.get(path).flatMap(Coerce::asDouble);
    }

    @Override
    public Optional<String> getString(DataQuery path) {
        return this.get(path).flatMap(Coerce::asString);
    }

    @Override
    public Optional<List<?>> getList(DataQuery path) {
        Optional<Object> val = this.get(path);
        if (val.isPresent()) {
            if (val.get() instanceof List) {
                return Optional.of(Lists.newArrayList((Iterable)((List)val.get())));
            }
            if (val.get() instanceof Object[]) {
                return Optional.of(Lists.newArrayList((Object[])((Object[])val.get())));
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<List<String>> getStringList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().map(Coerce::asString).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    private Optional<List<?>> getUnsafeList(DataQuery path) {
        return this.get(path).filter(obj -> obj instanceof List || obj instanceof Object[]).map(obj -> {
            if (obj instanceof List) {
                return (List)obj;
            }
            return Arrays.asList((Object[])obj);
        });
    }

    @Override
    public Optional<List<Character>> getCharacterList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().map(Coerce::asChar).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<Boolean>> getBooleanList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().map(Coerce::asBoolean).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<Byte>> getByteList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().map(Coerce::asByte).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<Short>> getShortList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().map(Coerce::asShort).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<Integer>> getIntegerList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().map(Coerce::asInteger).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<Long>> getLongList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().map(Coerce::asLong).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<Float>> getFloatList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().map(Coerce::asFloat).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<Double>> getDoubleList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().map(Coerce::asDouble).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<Map<?, ?>>> getMapList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().filter(obj -> obj instanceof Map).map(obj -> (Map)obj).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<DataView>> getViewList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().filter(obj -> obj instanceof DataView).map(obj -> (DataView)obj).collect(Collectors.toList()));
    }

    @Override
    public <T extends DataSerializable> Optional<T> getSerializable(DataQuery path, Class<T> clazz) {
        Optional<T> catalog;
        Preconditions.checkNotNull((Object)path, (Object)"path");
        Preconditions.checkNotNull(clazz, (Object)"clazz");
        if (clazz.isAssignableFrom(CatalogType.class) && (catalog = this.getCatalogType(path, clazz)).isPresent()) {
            return catalog;
        }
        return this.getUnsafeView(path).flatMap(view -> Sponge.getDataManager().getBuilder(clazz).flatMap(builder -> builder.build((DataView)view)));
    }

    @Override
    public <T extends DataSerializable> Optional<List<T>> getSerializableList(DataQuery path, Class<T> clazz) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        Preconditions.checkNotNull(clazz, (Object)"clazz");
        return Stream.of(() -> {
            if (clazz.isAssignableFrom(CatalogType.class)) {
                return this.getCatalogTypeList(path, clazz);
            }
            return Optional.empty();
        }, () -> this.getViewList(path).flatMap(list -> Sponge.getDataManager().getBuilder(clazz).map(builder -> list.stream().map(builder::build).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())))).map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Override
    public <T extends CatalogType> Optional<T> getCatalogType(DataQuery path, Class<T> catalogType) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        Preconditions.checkNotNull(catalogType, (Object)"dummy type");
        return this.getString(path).flatMap(string -> Sponge.getRegistry().getType(catalogType, (String)string));
    }

    @Override
    public <T extends CatalogType> Optional<List<T>> getCatalogTypeList(DataQuery path, Class<T> catalogType) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        Preconditions.checkNotNull(catalogType, (Object)"catalogType");
        return this.getStringList(path).map(list -> list.stream().map(string -> Sponge.getRegistry().getType(catalogType, (String)string)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public <T> Optional<T> getObject(DataQuery path, Class<T> objectClass) {
        return this.getView(path).flatMap(view -> Sponge.getDataManager().getSerializer(objectClass).flatMap(serializer -> serializer.deserialize((DataView)view)));
    }

    @Override
    public <T> Optional<List<T>> getObjectList(DataQuery path, Class<T> objectClass) {
        return this.getViewList(path).flatMap(viewList -> Sponge.getDataManager().getSerializer(objectClass).map(serializer -> viewList.stream().map(serializer::deserialize).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())));
    }

    @Override
    public DataContainer copy() {
        MemoryDataContainer container = new MemoryDataContainer();
        this.getKeys(false).stream().forEach(query -> this.get((DataQuery)query).ifPresent(obj -> container.set((DataQuery)query, obj)));
        return container;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.map, this.path});
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryDataView other = (MemoryDataView)obj;
        return Objects.equal(this.map.entrySet(), other.map.entrySet()) && Objects.equal((Object)this.path, (Object)other.path);
    }

    public String toString() {
        Objects.ToStringHelper helper = Objects.toStringHelper((Object)this);
        if (!this.path.toString().isEmpty()) {
            helper.add("path", (Object)this.path);
        }
        return helper.add("map", this.map).toString();
    }
}

