/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.key;

import com.google.common.base.Objects;
import java.util.Optional;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.api.data.value.mutable.MapValue;
import org.spongepowered.api.data.value.mutable.OptionalValue;
import org.spongepowered.api.data.value.mutable.SetValue;

public final class KeyFactory {
    private KeyFactory() {
    }

    public static <E, T extends BaseValue, V extends BaseValue<E>> Key<V> makeSingleKey(final Class<E> elementClass, final Class<T> valueClass, final DataQuery query) {
        return new Key<V>(){
            private final int hash;
            {
                this.hash = Objects.hashCode((Object[])new Object[]{elementClass, valueClass, query});
            }

            @Override
            public Class<V> getValueClass() {
                return valueClass;
            }

            @Override
            public DataQuery getQuery() {
                return query;
            }

            public int hashCode() {
                return this.hash;
            }

            public String toString() {
                return "Key{Value:" + valueClass.getSimpleName() + "<" + elementClass.getSimpleName() + ">, Query: " + query.toString() + "}";
            }
        };
    }

    public static <E> Key<ListValue<E>> makeListKey(final Class<E> elementClass, final DataQuery query) {
        return new Key<ListValue<E>>(){
            private final int hash;
            {
                this.hash = Objects.hashCode((Object[])new Object[]{ListValue.class, elementClass, query});
            }

            @Override
            public Class<ListValue<E>> getValueClass() {
                return ListValue.class;
            }

            @Override
            public DataQuery getQuery() {
                return query;
            }

            public int hashCode() {
                return this.hash;
            }

            public String toString() {
                return "Key{Value:ListValue<" + elementClass.getSimpleName() + ">, Query: " + query.toString() + "}";
            }
        };
    }

    public static <E> Key<SetValue<E>> makeSetKey(final Class<E> elementClass, final DataQuery query) {
        return new Key<SetValue<E>>(){
            private final int hash;
            {
                this.hash = Objects.hashCode((Object[])new Object[]{ListValue.class, elementClass, query});
            }

            @Override
            public Class<SetValue<E>> getValueClass() {
                return SetValue.class;
            }

            @Override
            public DataQuery getQuery() {
                return query;
            }

            public int hashCode() {
                return this.hash;
            }

            public String toString() {
                return "Key{Value:SetValue<" + elementClass.getSimpleName() + ">, Query: " + query.toString() + "}";
            }
        };
    }

    public static <K, V> Key<MapValue<K, V>> makeMapKey(final Class<K> keyClass, final Class<V> valueclass, final DataQuery query) {
        return new Key<MapValue<K, V>>(){
            private final int hash;
            {
                this.hash = Objects.hashCode((Object[])new Object[]{keyClass, valueclass, query});
            }

            @Override
            public Class<MapValue<K, V>> getValueClass() {
                return MapValue.class;
            }

            @Override
            public DataQuery getQuery() {
                return query;
            }

            public int hashCode() {
                return this.hash;
            }

            public String toString() {
                return "Key{Value:MapValue<" + keyClass.getSimpleName() + "," + valueclass.getSimpleName() + ">, Query: " + query.toString() + "}";
            }
        };
    }

    public static <E> Key<OptionalValue<E>> makeOptionalKey(final Class<E> elementClass, final DataQuery query) {
        return new Key<OptionalValue<E>>(){
            private final int hash;
            {
                this.hash = Objects.hashCode((Object[])new Object[]{Optional.class, elementClass, query});
            }

            @Override
            public Class<OptionalValue<E>> getValueClass() {
                return OptionalValue.class;
            }

            @Override
            public DataQuery getQuery() {
                return query;
            }

            public int hashCode() {
                return this.hash;
            }

            public String toString() {
                return "Key{Value:OptionalValue<" + elementClass.getSimpleName() + ">, Query: " + query.toString() + "}";
            }
        };
    }

    static <E, V extends BaseValue<E>> Key<V> fake(final String keyName) {
        return new Key<V>(){

            @Override
            public Class<V> getValueClass() {
                throw new UnsupportedOperationException("Key " + keyName + " is not implemented");
            }

            @Override
            public DataQuery getQuery() {
                throw new UnsupportedOperationException("Key " + keyName + " is not implemented");
            }
        };
    }
}

