/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.manipulator.immutable.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;

public abstract class AbstractImmutableData<I extends ImmutableDataManipulator<I, M>, M extends DataManipulator<M, I>>
implements ImmutableDataManipulator<I, M> {
    private final Map<Key<?>, Supplier<ImmutableValue<?>>> keyValueMap = Maps.newHashMap();
    private final Map<Key<?>, Supplier<?>> keyFieldGetterMap = Maps.newHashMap();

    protected AbstractImmutableData() {
    }

    protected final void registerKeyValue(Key<?> key, Supplier<ImmutableValue<?>> function) {
        this.keyValueMap.put((Key<?>)Preconditions.checkNotNull(key), (Supplier<ImmutableValue<?>>)Preconditions.checkNotNull(function));
    }

    protected final void registerFieldGetter(Key<?> key, Supplier<?> function) {
        this.keyFieldGetterMap.put((Key<?>)Preconditions.checkNotNull(key), (Supplier<?>)Preconditions.checkNotNull(function));
    }

    protected abstract void registerGetters();

    @Override
    public final I copy() {
        return (I)this;
    }

    @Override
    public <E> Optional<E> get(Key<? extends BaseValue<E>> key) {
        if (!this.supports(key)) {
            return Optional.empty();
        }
        return Optional.of(this.keyFieldGetterMap.get(key).get());
    }

    @Override
    public <E, V extends BaseValue<E>> Optional<V> getValue(Key<V> key) {
        if (!this.keyValueMap.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.of((BaseValue)Preconditions.checkNotNull(this.keyValueMap.get(key).get()));
    }

    @Override
    public boolean supports(Key<?> key) {
        return this.keyFieldGetterMap.containsKey(Preconditions.checkNotNull(key));
    }

    @Override
    public Set<Key<?>> getKeys() {
        return ImmutableSet.copyOf(this.keyValueMap.keySet());
    }

    @Override
    public Set<ImmutableValue<?>> getValues() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Supplier<ImmutableValue<?>> function : this.keyValueMap.values()) {
            builder.add(Preconditions.checkNotNull(function.get()));
        }
        return builder.build();
    }

    public int hashCode() {
        return Objects.hashCode(this.keyFieldGetterMap.values().stream().map(Supplier::get).collect(Collectors.toList()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractImmutableData other = (AbstractImmutableData)obj;
        return Objects.equals(this.keyFieldGetterMap.values().stream().map(Supplier::get).collect(Collectors.toList()), other.keyFieldGetterMap.values().stream().map(Supplier::get).collect(Collectors.toList()));
    }

    @Override
    public DataContainer toContainer() {
        return new MemoryDataContainer().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion());
    }
}

