/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.manipulator.immutable.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.immutable.ImmutableMappedData;
import org.spongepowered.api.data.manipulator.immutable.common.AbstractImmutableSingleData;
import org.spongepowered.api.data.manipulator.mutable.MappedData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableMapValue;

public abstract class AbstractImmutableMappedData<K, V, I extends ImmutableMappedData<K, V, I, M>, M extends MappedData<K, V, M, I>>
extends AbstractImmutableSingleData<Map<K, V>, I, M>
implements ImmutableMappedData<K, V, I, M> {
    private final ImmutableMapValue<K, V> mapValue;

    protected AbstractImmutableMappedData(Map<K, V> value, Key<? extends BaseValue<Map<K, V>>> usedKey) {
        super(ImmutableMap.copyOf(value), usedKey);
        this.mapValue = Sponge.getRegistry().getValueFactory().createMapValue(this.usedKey, (Map)this.value).asImmutable();
    }

    protected final ImmutableMapValue<K, V> getValueGetter() {
        return this.mapValue;
    }

    @Override
    public int compareTo(I o) {
        Map thisMap = (Map)this.getValue();
        Map otherMap = o.asMap();
        Set thisKeySet = thisMap.keySet();
        Set otherKeySet = otherMap.keySet();
        Collection thisValueSet = thisMap.values();
        Collection otherValueSet = otherMap.values();
        return ComparisonChain.start().compare((Comparable)Boolean.valueOf(thisKeySet.containsAll(otherKeySet)), (Comparable)Boolean.valueOf(otherKeySet.containsAll(thisKeySet))).compare((Comparable)Boolean.valueOf(thisValueSet.containsAll(otherValueSet)), (Comparable)Boolean.valueOf(otherValueSet.containsAll(thisValueSet))).result();
    }

    @Override
    public Optional<V> get(K key) {
        return Optional.ofNullable(((Map)super.getValue()).get(Preconditions.checkNotNull(key, (Object)"Key cannot be null!")));
    }

    @Override
    public Set<K> getMapKeys() {
        return ((Map)super.getValue()).keySet();
    }

    @Override
    public ImmutableMapValue<K, V> getMapValue() {
        return this.mapValue;
    }
}

