/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.manipulator.mutable.common;

import com.google.common.base.Preconditions;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.mutable.common.AbstractSingleData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.Value;

public abstract class AbstractSingleEnumData<E extends Enum<E>, M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>>
extends AbstractSingleData<E, M, I> {
    private final E defaultValue;

    protected AbstractSingleEnumData(E value, Key<? extends BaseValue<E>> usedKey, E defaultValue) {
        super(value, usedKey);
        this.defaultValue = (Enum)Preconditions.checkNotNull(defaultValue);
    }

    @Override
    public int compareTo(M o) {
        return ((Enum)o.get(this.usedKey).get()).ordinal() - ((Enum)this.getValue()).ordinal();
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(this.usedKey.getQuery(), (Object)((Enum)this.getValue()).name());
    }

    @Override
    protected Value<E> getValueGetter() {
        return Sponge.getRegistry().getValueFactory().createValue(this.usedKey, this.getValue(), this.defaultValue);
    }
}

