/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.property;

import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.property.AbstractProperty;
import org.spongepowered.api.util.Coerce;

public class BooleanProperty
extends AbstractProperty<String, Boolean> {
    public BooleanProperty(boolean value) {
        super(Coerce.toBoolean(value));
    }

    public BooleanProperty(boolean value, Property.Operator operator) {
        super(value, operator);
    }

    public BooleanProperty(Object value, Property.Operator operator) {
        super(Coerce.toBoolean(value), operator);
    }

    @Override
    public int compareTo(Property<?, ?> other) {
        return ((Boolean)this.getValue()).compareTo(other == null || Coerce.toBoolean(other.getValue()));
    }

    public static BooleanProperty of(Object value) {
        return new BooleanProperty(value, Property.Operator.EQUAL);
    }

    public static BooleanProperty not(Object value) {
        return new BooleanProperty(value, Property.Operator.NOTEQUAL);
    }

    public static BooleanProperty greaterThan(Object value) {
        return new BooleanProperty(value, Property.Operator.GREATER);
    }

    public static BooleanProperty greaterThanOrEqual(Object value) {
        return new BooleanProperty(value, Property.Operator.GEQUAL);
    }

    public static BooleanProperty lessThan(Object value) {
        return new BooleanProperty(value, Property.Operator.LESS);
    }

    public static BooleanProperty lessThanOrEqual(Object value) {
        return new BooleanProperty(value, Property.Operator.LEQUAL);
    }
}

