/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.property;

import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.property.AbstractProperty;
import org.spongepowered.api.util.Coerce;

public class DoubleProperty
extends AbstractProperty<String, Double> {
    public DoubleProperty(double value) {
        super(Coerce.toDouble(value));
    }

    public DoubleProperty(double value, Property.Operator operator) {
        super(value, operator);
    }

    public DoubleProperty(Object value, Property.Operator operator) {
        super(Coerce.toDouble(value), operator);
    }

    @Override
    public int compareTo(Property<?, ?> other) {
        return ((Double)this.getValue()).compareTo(other == null ? 1.0 : Coerce.toDouble(other.getValue()));
    }

    public static DoubleProperty of(Object value) {
        return new DoubleProperty(value, Property.Operator.EQUAL);
    }

    public static DoubleProperty not(Object value) {
        return new DoubleProperty(value, Property.Operator.NOTEQUAL);
    }

    public static DoubleProperty greaterThan(Object value) {
        return new DoubleProperty(value, Property.Operator.GREATER);
    }

    public static DoubleProperty greaterThanOrEqual(Object value) {
        return new DoubleProperty(value, Property.Operator.GEQUAL);
    }

    public static DoubleProperty lessThan(Object value) {
        return new DoubleProperty(value, Property.Operator.LESS);
    }

    public static DoubleProperty lessThanOrEqual(Object value) {
        return new DoubleProperty(value, Property.Operator.LEQUAL);
    }
}

