/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.translator;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.SimpleConfigurationNode;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.data.translator.DataTranslator;

public final class ConfigurateTranslator
implements DataTranslator<ConfigurationNode> {
    private static final ConfigurateTranslator instance = new ConfigurateTranslator();

    private ConfigurateTranslator() {
    }

    public static ConfigurateTranslator instance() {
        return instance;
    }

    private static void populateNode(ConfigurationNode node, DataView container) {
        Preconditions.checkNotNull((Object)node, (Object)"node");
        Preconditions.checkNotNull((Object)container, (Object)"container");
        node.setValue(container.getMap(DataQuery.of()).get());
    }

    private static DataContainer translateFromNode(ConfigurationNode node) {
        Preconditions.checkNotNull((Object)node, (Object)"node");
        MemoryDataContainer dataContainer = new MemoryDataContainer();
        Object value = node.getValue();
        Object key = node.getKey();
        if (value != null) {
            if (key == null || value instanceof Map || value instanceof List) {
                ConfigurateTranslator.translateMapOrList(node, dataContainer);
            } else {
                dataContainer.set(DataQuery.of('.', key.toString()), value);
            }
        }
        return dataContainer;
    }

    private static void translateMapOrList(ConfigurationNode node, DataView container) {
        Object value = node.getValue();
        if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                container.set(DataQuery.of('.', entry.getKey().toString()), entry.getValue());
            }
        } else if (value != null) {
            container.set(DataQuery.of(node.getKey().toString()), value);
        }
    }

    @Override
    public ConfigurationNode translateData(DataView container) {
        SimpleConfigurationNode node = SimpleConfigurationNode.root();
        this.translateContainerToData((ConfigurationNode)node, container);
        return node;
    }

    @Override
    public void translateContainerToData(ConfigurationNode node, DataView container) {
        ConfigurateTranslator.populateNode(node, container);
    }

    @Override
    public DataContainer translateFrom(ConfigurationNode node) {
        return ConfigurateTranslator.translateFromNode(node);
    }
}

