/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.value;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;

public interface ValueContainer<C extends ValueContainer<C>> {
    public <E> Optional<E> get(Key<? extends BaseValue<E>> var1);

    @Nullable
    default public <E> E getOrNull(Key<? extends BaseValue<E>> key) {
        Optional<E> value = this.get(key);
        if (value.isPresent()) {
            return value.get();
        }
        if (!this.supports(key)) {
            throw new UnsupportedOperationException("Key not supported. Key: " + key);
        }
        return null;
    }

    default public <E> E getOrElse(Key<? extends BaseValue<E>> key, E defaultValue) {
        return (E)this.get(key).orElse(Preconditions.checkNotNull(defaultValue, (Object)"Provided a null default value for 'getOrElse(Key, null)'!"));
    }

    public <E, V extends BaseValue<E>> Optional<V> getValue(Key<V> var1);

    public boolean supports(Key<?> var1);

    default public boolean supports(BaseValue<?> baseValue) {
        return this.supports(baseValue.getKey());
    }

    public C copy();

    public Set<Key<?>> getKeys();

    public Set<ImmutableValue<?>> getValues();
}

