/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.entity;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.util.RelativePositions;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public interface Entity
extends Identifiable,
DataHolder,
DataSerializable,
Translatable {
    public EntityType getType();

    public World getWorld();

    public EntitySnapshot createSnapshot();

    public Random getRandom();

    public Location<World> getLocation();

    public boolean setLocation(Location<World> var1);

    public boolean setLocationSafely(Location<World> var1);

    public Vector3d getRotation();

    public void setRotation(Vector3d var1);

    public boolean setLocationAndRotation(Location<World> var1, Vector3d var2);

    public boolean setLocationAndRotationSafely(Location<World> var1, Vector3d var2);

    public boolean setLocationAndRotation(Location<World> var1, Vector3d var2, EnumSet<RelativePositions> var3);

    public boolean setLocationAndRotationSafely(Location<World> var1, Vector3d var2, EnumSet<RelativePositions> var3);

    public Vector3d getScale();

    public void setScale(Vector3d var1);

    public Transform<World> getTransform();

    public boolean setTransform(Transform<World> var1);

    public boolean transferToWorld(String var1, Vector3d var2);

    public boolean transferToWorld(UUID var1, Vector3d var2);

    public Optional<Entity> getPassenger();

    public DataTransactionResult setPassenger(@Nullable Entity var1);

    public Optional<Entity> getVehicle();

    public DataTransactionResult setVehicle(@Nullable Entity var1);

    public Entity getBaseVehicle();

    default public Vector3d getVelocity() {
        return this.get(Keys.VELOCITY).get();
    }

    default public DataTransactionResult setVelocity(Vector3d vector3d) {
        return this.offer(Keys.VELOCITY, vector3d);
    }

    public boolean isOnGround();

    public boolean isRemoved();

    public boolean isLoaded();

    public void remove();

    default public boolean damage(double damage, DamageSource damageSource) {
        return this.damage(damage, damageSource, Cause.source(damageSource).build());
    }

    public boolean damage(double var1, DamageSource var3, Cause var4);

    default public Collection<Entity> getNearbyEntities(double distance) {
        Preconditions.checkArgument((distance > 0.0 ? 1 : 0) != 0, (Object)"Distance must be above zero!");
        return this.getNearbyEntities(entity -> entity.getTransform().getPosition().distance(this.getTransform().getPosition()) <= distance);
    }

    default public Collection<Entity> getNearbyEntities(Predicate<Entity> predicate) {
        Preconditions.checkNotNull(predicate, (Object)"Null predicate!");
        return this.getWorld().getEntities(predicate::test);
    }

    public Optional<UUID> getCreator();

    public Optional<UUID> getNotifier();

    public void setCreator(@Nullable UUID var1);

    public void setNotifier(@Nullable UUID var1);

    default public boolean canSee(Entity entity) {
        Optional<Boolean> optional = entity.get(Keys.INVISIBLE);
        return !optional.isPresent() || optional.get() == false;
    }
}

