/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.entity.living.player;

import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.command.source.LocatedSource;
import org.spongepowered.api.command.source.RemoteSource;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.DisplayNameData;
import org.spongepowered.api.data.manipulator.mutable.entity.GameModeData;
import org.spongepowered.api.data.manipulator.mutable.entity.JoinData;
import org.spongepowered.api.data.type.SkinPart;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.effect.Viewer;
import org.spongepowered.api.entity.living.Humanoid;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.network.PlayerConnection;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.ChatTypeMessageReceiver;
import org.spongepowered.api.text.chat.ChatVisibility;

public interface Player
extends Humanoid,
User,
LocatedSource,
RemoteSource,
Viewer,
ChatTypeMessageReceiver {
    public boolean isViewingInventory();

    public Optional<Inventory> getOpenInventory();

    public void openInventory(Inventory var1, Cause var2) throws IllegalArgumentException;

    public void closeInventory(Cause var1) throws IllegalArgumentException;

    public int getViewDistance();

    public ChatVisibility getChatVisibility();

    public boolean isChatColorsEnabled();

    public Set<SkinPart> getDisplayedSkinParts();

    @Override
    public PlayerConnection getConnection();

    public void sendResourcePack(ResourcePack var1);

    public TabList getTabList();

    public void kick();

    public void kick(Text var1);

    public Scoreboard getScoreboard();

    public void setScoreboard(Scoreboard var1);

    default public JoinData getJoinData() {
        return this.get(JoinData.class).get();
    }

    default public Value<Instant> firstPlayed() {
        return this.getValue(Keys.FIRST_DATE_PLAYED).get();
    }

    default public Value<Instant> lastPlayed() {
        return this.getValue(Keys.LAST_DATE_PLAYED).get();
    }

    default public boolean hasPlayedBefore() {
        return !this.firstPlayed().equals(this.lastPlayed());
    }

    default public DisplayNameData getDisplayNameData() {
        return this.get(DisplayNameData.class).get();
    }

    default public GameModeData getGameModeData() {
        return this.get(GameModeData.class).get();
    }

    default public Value<GameMode> gameMode() {
        return this.getValue(Keys.GAME_MODE).get();
    }

    public boolean isSleepingIgnored();

    public void setSleepingIgnored(boolean var1);
}

