/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.world.TargetWorldEvent;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public interface AffectEntityEvent
extends TargetWorldEvent,
Cancellable {
    public List<EntitySnapshot> getEntitySnapshots();

    public List<Entity> getEntities();

    default public List<Entity> filterEntityLocations(Predicate<Location<World>> predicate) {
        ArrayList<Entity> removedEntiies = new ArrayList<Entity>();
        Iterator<Entity> i = this.getEntities().iterator();
        while (i.hasNext()) {
            Entity entity = i.next();
            if (predicate.test(entity.getLocation())) continue;
            i.remove();
            removedEntiies.add(entity);
        }
        return removedEntiies;
    }

    default public List<? extends Entity> filterEntities(Predicate<Entity> predicate) {
        ArrayList<Entity> removedEntiies = new ArrayList<Entity>();
        Iterator<Entity> i = this.getEntities().iterator();
        while (i.hasNext()) {
            Entity entity = i.next();
            if (predicate.test(entity)) continue;
            i.remove();
            removedEntiies.add(entity);
        }
        return removedEntiies;
    }
}

