/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.action.CollideEvent;
import org.spongepowered.api.event.world.TargetWorldEvent;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public interface CollideEntityEvent
extends CollideEvent,
TargetWorldEvent {
    public List<Entity> getOriginalEntities();

    public List<Entity> getEntities();

    default public List<Entity> filterEntityLocations(Predicate<Location<World>> predicate) {
        ArrayList removedEntites = Lists.newArrayList();
        for (Entity entity : this.getEntities()) {
            if (predicate.test(entity.getLocation())) continue;
            removedEntites.add(entity);
        }
        this.getEntities().removeAll(removedEntites);
        return removedEntites;
    }

    default public List<Entity> filterEntities(Predicate<Entity> predicate) {
        ArrayList removedEntites = Lists.newArrayList();
        for (Entity entity : this.getEntities()) {
            if (predicate.test(entity)) continue;
            removedEntites.add(entity);
        }
        this.getEntities().removeAll(removedEntites);
        return removedEntites;
    }

    public static interface Impact
    extends CollideEntityEvent,
    CollideEvent.Impact {
    }
}

