/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.extra.skylands;

import com.flowpowered.math.vector.Vector3i;
import com.flowpowered.noise.module.Module;
import com.flowpowered.noise.module.source.Voronoi;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.PlantType;
import org.spongepowered.api.data.type.PlantTypes;
import org.spongepowered.api.data.type.ShrubTypes;
import org.spongepowered.api.extra.skylands.SkylandsUtil;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.ImmutableBiomeArea;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.gen.GenerationPopulator;

public class SkylandsGrassPopulator
implements GenerationPopulator {
    private static final double GRASS_ODDS = 0.3;
    private static final double DOUBLE_GRASS_ODDS = 0.9;
    private static final double COVERED_GRASS_ODDS = 0.8;
    private static final BlockState TALL_GRASS;
    private static final Flower[] FLOWERS;
    private final Voronoi flowerCells = new Voronoi();
    private final Voronoi flowerDensities = new Voronoi();
    private final RarityCurve flowerOdds = new RarityCurve();

    public SkylandsGrassPopulator() {
        this.flowerCells.setFrequency(0.1);
        this.flowerCells.setDisplacement((double)(FLOWERS.length - 1));
        this.flowerCells.setEnableDistance(false);
        this.flowerDensities.setFrequency(0.1);
        this.flowerDensities.setDisplacement(0.0);
        this.flowerDensities.setEnableDistance(true);
        this.flowerOdds.setSourceModule(0, (Module)this.flowerDensities);
        this.flowerOdds.setDegree(5.0);
    }

    @Override
    public void populate(World world, MutableBlockVolume buffer, ImmutableBiomeArea biomes) {
        Vector3i max = buffer.getBlockMax();
        Vector3i min = buffer.getBlockMin();
        int yMax = max.getY() - 2;
        int yMin = min.getY();
        if (yMax < 29 || yMin > 111) {
            return;
        }
        long seed = world.getProperties().getSeed();
        int intSeed = (int)(seed >> 32 ^ seed);
        int intSeed2 = intSeed * 28703;
        int yStart = Math.min(yMax, 111);
        int yEnd = Math.max(yMin, 29);
        int xMin = min.getX();
        int zMin = min.getZ();
        int xMax = max.getX();
        int zMax = max.getZ();
        for (int zz = zMin; zz <= zMax; ++zz) {
            for (int xx = xMin; xx <= xMax; ++xx) {
                int yy = SkylandsUtil.getNextSolid(buffer, xx, yStart, zz, yEnd);
                if (yy < yEnd) continue;
                if (buffer.getBlockType(xx, yy, zz) == BlockTypes.GRASS) {
                    float value = SkylandsUtil.hashToFloat(xx, zz, seed);
                    this.flowerCells.setSeed(intSeed);
                    this.flowerDensities.setSeed(intSeed);
                    Flower flower = FLOWERS[(int)this.flowerCells.getValue((double)xx, 0.0, (double)zz)];
                    if (flower == null || (double)value < this.flowerOdds.getValue(xx, 0.0, zz)) {
                        this.flowerCells.setSeed(intSeed2);
                        this.flowerDensities.setSeed(intSeed2);
                        flower = FLOWERS[(int)this.flowerCells.getValue((double)xx, 0.0, (double)zz)];
                        if (flower != null && (double)value < this.flowerOdds.getValue(xx, 0.0, zz)) {
                            flower = null;
                        }
                    }
                    if (flower != null) {
                        buffer.setBlock(xx, yy + 1, zz, flower.getBlock());
                        if (flower.isDoubleHeight()) {
                            buffer.setBlock(xx, yy + 2, zz, flower.getUpperBlock());
                        }
                    } else if ((double)value >= 0.3) {
                        if ((double)value >= 0.9 && yy + 1 < yMax) {
                            buffer.setBlock(xx, yy + 1, zz, TALL_GRASS);
                        } else {
                            buffer.setBlock(xx, yy + 1, zz, TALL_GRASS);
                        }
                    }
                }
                yy = SkylandsUtil.getNextAir(buffer, xx, yy, zz, yEnd);
                yy = SkylandsUtil.getNextSolid(buffer, xx, yy, zz, yEnd);
                int layerNumber = 0;
                while (yy >= yEnd) {
                    float value;
                    if (buffer.getBlockType(xx, yy, zz) == BlockTypes.GRASS && (double)(value = SkylandsUtil.hashToFloat(xx, layerNumber, zz, seed)) >= 0.8) {
                        buffer.setBlock(xx, yy + 1, zz, TALL_GRASS);
                    }
                    ++layerNumber;
                    yy = SkylandsUtil.getNextAir(buffer, xx, yy, zz, yEnd);
                    yy = SkylandsUtil.getNextSolid(buffer, xx, yy, zz, yEnd);
                }
            }
        }
    }

    static {
        FLOWERS = new Flower[]{new Flower(BlockTypes.YELLOW_FLOWER), new Flower(PlantTypes.WHITE_TULIP), new Flower(PlantTypes.ORANGE_TULIP), new Flower(PlantTypes.BLUE_ORCHID), new Flower(PlantTypes.HOUSTONIA), new Flower(PlantTypes.POPPY), null, null, null, null, null, null};
        BlockState defaultGrass = BlockTypes.TALLGRASS.getDefaultState();
        TALL_GRASS = (BlockState)defaultGrass.with(Keys.SHRUB_TYPE, ShrubTypes.TALL_GRASS).get();
    }

    private static class RarityCurve
    extends Module {
        private double degree;

        RarityCurve() {
            super(1);
        }

        void setDegree(double degree) {
            this.degree = degree;
        }

        public int getSourceModuleCount() {
            return 1;
        }

        public double getValue(double x, double y, double z) {
            double value = this.sourceModule[0].getValue(x, y, z);
            return 1.0 - Math.pow(1.0 - value, this.degree);
        }
    }

    private static class Flower {
        private static final BlockState DEFAULT_FLOWER = BlockTypes.RED_FLOWER.getDefaultState();
        private final BlockState block;
        private final boolean doubleHeight;
        private final BlockState upperBlock;

        Flower(PlantType type) {
            this((BlockState)DEFAULT_FLOWER.with(Keys.PLANT_TYPE, type).get(), false);
        }

        Flower(BlockType block) {
            this(block.getDefaultState(), false);
        }

        Flower(BlockState block, boolean doubleHeight) {
            this.block = block;
            this.doubleHeight = doubleHeight;
            this.upperBlock = this.block;
        }

        BlockState getBlock() {
            return this.block;
        }

        boolean isDoubleHeight() {
            return this.doubleHeight;
        }

        BlockState getUpperBlock() {
            return this.upperBlock;
        }
    }
}

