/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory.property;

import com.flowpowered.math.vector.Vector2i;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.item.inventory.property.AbstractInventoryProperty;
import org.spongepowered.api.util.Coerce;

public class InventorySize
extends AbstractInventoryProperty<String, Vector2i> {
    public InventorySize(Vector2i value) {
        super(value);
    }

    public InventorySize(int width, int height) {
        super(new Vector2i(width, height));
    }

    public InventorySize(Vector2i value, Property.Operator operator) {
        super(value, operator);
    }

    public InventorySize(int width, int height, Property.Operator operator) {
        super(new Vector2i(width, height), operator);
    }

    public InventorySize(Object value, Property.Operator operator) {
        super(Coerce.toVector2i(value), operator);
    }

    public int getColumns() {
        return ((Vector2i)this.getValue()).getX();
    }

    public int getRows() {
        return ((Vector2i)this.getValue()).getY();
    }

    @Override
    public int compareTo(Property<?, ?> other) {
        if (other == null) {
            return 1;
        }
        return ((Vector2i)this.getValue()).compareTo(Coerce.toVector2i(other.getValue()));
    }

    public static InventorySize of(Object value) {
        return new InventorySize(value, Property.Operator.EQUAL);
    }

    public static InventorySize of(int width, int height) {
        return new InventorySize(new Vector2i(width, height), Property.Operator.EQUAL);
    }

    public static InventorySize not(Object value) {
        return new InventorySize(value, Property.Operator.NOTEQUAL);
    }

    public static InventorySize greaterThan(Object value) {
        return new InventorySize(value, Property.Operator.GREATER);
    }

    public static InventorySize greaterThanOrEqual(Object value) {
        return new InventorySize(value, Property.Operator.GEQUAL);
    }

    public static InventorySize lessThan(Object value) {
        return new InventorySize(value, Property.Operator.LESS);
    }

    public static InventorySize lessThanOrEqual(Object value) {
        return new InventorySize(value, Property.Operator.LEQUAL);
    }
}

