/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.scoreboard.objective;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.critieria.Criterion;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayMode;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.ResettableBuilder;

public interface Objective {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public String getName();

    public Text getDisplayName();

    public void setDisplayName(Text var1) throws IllegalArgumentException;

    public Criterion getCriterion();

    public ObjectiveDisplayMode getDisplayMode();

    public void setDisplayMode(ObjectiveDisplayMode var1);

    public Map<Text, Score> getScores();

    public boolean hasScore(Text var1);

    public void addScore(Score var1) throws IllegalArgumentException;

    default public Optional<Score> getScore(Text name) {
        if (!this.hasScore(name)) {
            return Optional.empty();
        }
        return Optional.of(this.getOrCreateScore(name));
    }

    public Score getOrCreateScore(Text var1);

    public boolean removeScore(Score var1);

    public boolean removeScore(Text var1);

    public Set<Scoreboard> getScoreboards();

    public static interface Builder
    extends ResettableBuilder<Objective, Builder> {
        public Builder name(String var1);

        public Builder displayName(Text var1);

        public Builder criterion(Criterion var1);

        public Builder objectiveDisplayMode(ObjectiveDisplayMode var1);

        public Objective build() throws IllegalStateException;
    }
}

